/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.service;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.confluence.azure.ao.AzureDevOpsConfigurationRepository;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.model.AzureGlobalSettings;
import com.moveworkforward.confluence.azure.service.AzureDevOpsGlobalConfigurationService;
import com.moveworkforward.confluence.azure.service.AzureGlobalSettingsService;
import com.moveworkforward.confluence.common.service.AbstractConfigurationService;
import com.moveworkforward.confluence.common.service.MacroConfigurationService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class AzureDevOpsPersonalConfigurationService
implements MacroConfigurationService<AzureDevOpsConfiguration> {
    private boolean isDevMode = false;
    private final AzureDevOpsConfigurationRepository configurationRepository;
    private final PermissionManager permissionManager;
    private final AzureGlobalSettingsService globalSettingsService;

    @Autowired
    public AzureDevOpsPersonalConfigurationService(AzureDevOpsConfigurationRepository configurationRepository, PermissionManager permissionManager, AzureGlobalSettingsService globalSettingsService, Environment environment) {
        this.configurationRepository = configurationRepository;
        this.permissionManager = permissionManager;
        this.isDevMode = (Boolean)environment.getProperty("moveworkforward.dev.mode", Boolean.class, (Object)false);
        this.globalSettingsService = globalSettingsService;
    }

    public AzureDevOpsConfiguration get(String userKey, boolean checkPermissions) {
        if (StringUtils.isBlank((CharSequence)userKey)) {
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            userKey = confluenceUser.getKey().getStringValue();
        }
        if (checkPermissions) {
            this.checkPermissions(userKey);
        }
        AzureDevOpsConfiguration configuration = this.configurationRepository.getByTag(userKey).stream().findFirst().orElse(this.getDefaultConfiguration());
        if (this.isDevMode && StringUtils.isBlank((CharSequence)configuration.getConfiguration().getOrganization())) {
            configuration.getConfiguration().setOrganization("MoveWorkForward");
        }
        return configuration;
    }

    public AzureDevOpsConfiguration delete(String userKey) {
        AzureDevOpsConfiguration saved = this.get(userKey, AbstractConfigurationService.CHECK_PERMISSIONS);
        if (saved.getId() != null) {
            return (AzureDevOpsConfiguration)this.configurationRepository.delete(saved.getId());
        }
        return null;
    }

    public AzureDevOpsConfiguration save(AzureDevOpsConfiguration configuration) {
        if (StringUtils.isBlank((CharSequence)configuration.getUserKey())) {
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            configuration.setUserKey(confluenceUser.getKey().getStringValue());
        }
        this.checkPermissions(configuration.getUserKey());
        this.validate(configuration);
        AzureDevOpsConfiguration saved = this.get(configuration.getUserKey(), AbstractConfigurationService.DO_NOT_CHECK_PERMISSIONS);
        if (saved.getId() != null) {
            configuration.setId(saved.getId());
        }
        this.processMask(configuration, saved);
        return (AzureDevOpsConfiguration)this.configurationRepository.save((PluginEntity)configuration);
    }

    protected void processMask(AzureDevOpsConfiguration newConfiguration, AzureDevOpsConfiguration existingConfiguration) {
        AzureDevOpsGlobalConfigurationService.doProcessMask(newConfiguration, existingConfiguration);
    }

    protected void validate(AzureDevOpsConfiguration configuration) {
        AzureGlobalSettings globalSettings = this.globalSettingsService.get(AbstractConfigurationService.DO_NOT_CHECK_PERMISSIONS);
        if (!globalSettings.isAllowPersonal()) {
            throw new RuntimeException("Contact your administrator. Personal configurations are forbidden");
        }
        if (configuration.getConfiguration().isUseBaseUrl() && StringUtils.isBlank((CharSequence)configuration.getConfiguration().getBaseUrl())) {
            throw new RuntimeException("Base URL must be specified");
        }
        if (configuration.getConfiguration().isUseOrganization() && StringUtils.isBlank((CharSequence)configuration.getConfiguration().getOrganization())) {
            throw new RuntimeException("Organization must be specified");
        }
        configuration.setLevel(AzureDevOpsConfiguration.Level.PERSONAL);
    }

    public AzureDevOpsConfiguration getDefaultConfiguration() {
        AzureDevOpsConfiguration configuration = new AzureDevOpsConfiguration();
        configuration.setLevel(AzureDevOpsConfiguration.Level.PERSONAL);
        return configuration;
    }

    private void checkPermissions(String userKey) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!confluenceUser.getKey().getStringValue().equals(userKey) && !this.permissionManager.isConfluenceAdministrator((User)confluenceUser)) {
            throw new RuntimeException("User doesn't have permissions");
        }
    }

    public AzureDevOpsConfiguration get() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return this.get(confluenceUser.getKey().getStringValue(), AbstractConfigurationService.DO_NOT_CHECK_PERMISSIONS);
    }
}

