/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.model;

public enum IconProperty {
    Empty("", ""),
    Bug("bowtie-symbol-bug", "rgb(204, 41, 61)"),
    Feature("bowtie-symbol-trophy", "rgb(119, 59, 147)"),
    UserStory("bowtie-symbol-book", "rgb(0, 156, 204)"),
    Epic("bowtie-symbol-crown", "rgb(255, 123, 0)"),
    Task("bowtie-symbol-task", "rgb(242, 203, 29)"),
    TestCase("bowtie-test-case", "rgb(0, 75, 80)"),
    Issue("bowtie-symbol-issue", "rgb(51, 153, 71)");

    private String iconClass = "";
    private String iconColour = "";

    public static IconProperty fromWorkItemType(String workItemType) {
        IconProperty result = Empty;
        block4 : switch (workItemType) {
            case "User Story": {
                result = UserStory;
                break;
            }
            case "Test Case": {
                result = TestCase;
                break;
            }
            default: {
                for (IconProperty value : IconProperty.values()) {
                    if (!workItemType.equals(value.toString())) continue;
                    result = value;
                    break block4;
                }
            }
        }
        return result;
    }

    private IconProperty(String iconClass, String iconColour) {
        this.iconClass = iconClass;
        this.iconColour = iconColour;
    }

    private IconProperty() {
    }

    public String getIconClass() {
        return this.iconClass;
    }

    public String getIconColour() {
        return this.iconColour;
    }
}

