/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.service;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.ao.PluginSettingRepository;
import com.moveworkforward.confluence.azure.ao.AzureDevOpsConfigurationRepository;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.common.service.AbstractConfigurationService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class AzureDevOpsGlobalConfigurationService
extends AbstractConfigurationService<AzureDevOpsConfiguration> {
    private boolean isDevMode = false;

    @Autowired
    public AzureDevOpsGlobalConfigurationService(AzureDevOpsConfigurationRepository configurationRepository, @ComponentImport PermissionManager permissionManager, Environment environment) {
        super((PluginSettingRepository)configurationRepository, permissionManager);
        this.isDevMode = (Boolean)environment.getProperty("moveworkforward.dev.mode", Boolean.class, (Object)false);
    }

    public AzureDevOpsConfiguration get(boolean checkPermissions) {
        if (checkPermissions) {
            this.checkAdminPermissions();
        }
        AzureDevOpsConfiguration configuration = this.configurationRepository.getByTag("05f11044-da77-41a8-ac66-a9388ffd0925").stream().findFirst().orElse(this.getDefaultConfiguration());
        if (this.isDevMode && StringUtils.isBlank((CharSequence)configuration.getConfiguration().getOrganization())) {
            configuration.getConfiguration().setOrganization("MoveWorkForward");
        }
        return configuration;
    }

    public AzureDevOpsConfiguration getDefaultConfiguration() {
        return new AzureDevOpsConfiguration();
    }

    protected void processMask(AzureDevOpsConfiguration newConfiguration, AzureDevOpsConfiguration existingConfiguration) {
        AzureDevOpsGlobalConfigurationService.doProcessMask(newConfiguration, existingConfiguration);
    }

    protected static void doProcessMask(AzureDevOpsConfiguration newConfiguration, AzureDevOpsConfiguration existingConfiguration) {
        if ("XXXXXXXXX".equals(newConfiguration.getConfiguration().getPersonalAccessToken())) {
            newConfiguration.getConfiguration().setPersonalAccessToken(existingConfiguration.getConfiguration().getPersonalAccessToken());
        }
    }

    protected void validate(AzureDevOpsConfiguration configuration) {
        if (configuration.getConfiguration().isUseBaseUrl() && StringUtils.isBlank((CharSequence)configuration.getConfiguration().getBaseUrl())) {
            throw new RuntimeException("Base URL must be specified");
        }
        if (configuration.getConfiguration().isUseOrganization() && StringUtils.isBlank((CharSequence)configuration.getConfiguration().getOrganization())) {
            throw new RuntimeException("Organization must be specified");
        }
        configuration.setLevel(AzureDevOpsConfiguration.Level.GLOBAL);
    }
}

