/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.gitlab.model;

import com.moveworkforward.ao.entity.EntityType;
import com.moveworkforward.model.AbstractPluginEntity;
import java.util.UUID;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.gitlab.api.TokenType;

@EntityType(value="GITLAB_CONFIGURATION")
@JsonIgnoreProperties(ignoreUnknown=true, value={"key", "tag"})
@JsonAutoDetect
public class GitlabConfiguration
extends AbstractPluginEntity {
    private String apiKey;
    private TokenType tokenType;
    private HostType hostType;
    private String key;

    public String getKey() {
        if (this.key == null) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public HostType getHostType() {
        return this.hostType;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public void setHostType(HostType hostType) {
        this.hostType = hostType;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitlabConfiguration)) {
            return false;
        }
        GitlabConfiguration other = (GitlabConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof GitlabConfiguration;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        return "GitlabConfiguration(super=" + super.toString() + ", apiKey=" + this.getApiKey() + ", tokenType=" + this.getTokenType() + ", hostType=" + (Object)((Object)this.getHostType()) + ", key=" + this.getKey() + ")";
    }

    public static enum HostType {
        SERVER,
        CLOUD;

    }
}

