/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.gitlab.link;

import com.moveworkforward.confluence.gitlab.link.GitlabLinkHelper;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLinkHelper
implements GitlabLinkHelper {
    private static final Logger log = LoggerFactory.getLogger(AbstractLinkHelper.class);

    @Override
    public String getBaseUrl(String targetUrl) {
        try {
            URL url = new URL(targetUrl);
            return url.getProtocol() + "://" + url.getHost() + (url.getPort() > 0 ? ":" + url.getPort() : "");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String getProjectId(String targetUrl) {
        try {
            URL url = new URL(targetUrl);
            List<String> parts = this.splitUrl(url.getPath().replaceFirst("/", ""));
            int index = this.getKeyPathIndex(parts);
            return String.join((CharSequence)"/", parts.subList(0, index - 1));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String getUrlWithoutParameters(String url) {
        int index = url.indexOf("?");
        if (index > 0) {
            return url.substring(0, index);
        }
        return url;
    }

    @Override
    public String getId(String url) {
        List<String> parts = this.splitUrl(this.getUrlWithoutParameters(url));
        return parts.get(parts.size() - 1).startsWith(this.getKeyPath()) ? null : parts.get(parts.size() - 1);
    }

    @Override
    public String getParameters(String url) {
        String parameters = "";
        if (url.contains("?")) {
            parameters = url.substring(url.indexOf("?") + 1);
        }
        String string = parameters = StringUtils.isBlank((CharSequence)parameters) ? "scope=all&state=opened" : parameters;
        if (!parameters.contains("per_page")) {
            parameters = parameters + "&per_page=10";
        }
        return Arrays.asList(parameters.split("&")).stream().filter(s -> {
            String[] pair = s.split("=");
            return pair.length == 2 && StringUtils.isNotBlank((CharSequence)pair[0]) && StringUtils.isNotBlank((CharSequence)pair[1]) && !"sort".equals(pair[0]);
        }).collect(Collectors.joining("&"));
    }

    @Override
    public boolean isAccepted(String url) {
        return url.contains(this.getKeyPath());
    }

    public int getKeyPathIndex(List<String> parts) {
        return parts.indexOf(this.getKeyPath());
    }

    public abstract String getKeyPath();

    protected List<String> splitUrl(String url) {
        return Arrays.asList(url.split("/"));
    }
}

