/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.github.service;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.common.service.AbstractConfigurationService;
import com.moveworkforward.confluence.github.ao.GitHubConfigurationRepository;
import com.moveworkforward.confluence.github.model.GitHubConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitHubConfigurationService
extends AbstractConfigurationService<GitHubConfiguration> {
    @Autowired
    public GitHubConfigurationService(GitHubConfigurationRepository configurationRepository, @ComponentImport PermissionManager permissionManager) {
        super(configurationRepository, permissionManager);
    }

    @Override
    public GitHubConfiguration getDefaultConfiguration() {
        return new GitHubConfiguration();
    }

    @Override
    protected void validate(GitHubConfiguration configuration) {
        if (StringUtils.isBlank((CharSequence)configuration.getPersonalAccessToken())) {
            throw new RuntimeException("Personal access token must be specified");
        }
    }

    @Override
    protected void processMask(GitHubConfiguration newConfiguration, GitHubConfiguration existingConfiguration) {
        if ("XXXXXXXXX".equals(newConfiguration.getPersonalAccessToken())) {
            newConfiguration.setPersonalAccessToken(existingConfiguration.getPersonalAccessToken());
        }
    }
}

