/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.github.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.github.GitHubRestClient;
import com.moveworkforward.confluence.github.link.GitHubLinkHelper;
import com.moveworkforward.confluence.github.link.PullRequestLinkHelper;
import com.moveworkforward.confluence.github.model.GitHubConfiguration;
import com.moveworkforward.confluence.github.model.PullRequest;
import com.moveworkforward.confluence.github.processor.AbstractGitHubLinkProcessor;
import com.moveworkforward.confluence.github.service.GitHubConfigurationService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullRequestProcessor
extends AbstractGitHubLinkProcessor {
    private static final Logger log = LoggerFactory.getLogger(PullRequestProcessor.class);

    @Autowired
    public PullRequestProcessor(GitHubConfigurationService configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(configurationService, renderer, i18nResolver, webResourceUrlProvider, new PullRequestLinkHelper());
    }

    @Override
    protected String doProcess(Map<String, String> parameters, GitHubConfiguration configuration) {
        String url = this.getUrl(parameters);
        String id = ((GitHubLinkHelper)this.linkHelper).getId(url);
        if (StringUtils.isBlank((CharSequence)id)) {
            return this.processRequests(url, configuration);
        }
        return this.processRequest(url, configuration);
    }

    private String processRequest(String url, GitHubConfiguration configuration) {
        GitHubRestClient githubClient = this.getGitHubAPI(url, configuration);
        String id = ((GitHubLinkHelper)this.linkHelper).getId(url);
        String owner = ((GitHubLinkHelper)this.linkHelper).getOwner(url);
        String repo = ((GitHubLinkHelper)this.linkHelper).getRepo(url);
        PullRequest request = githubClient.getPullRequest(owner, repo, Integer.parseInt(id));
        return this.render(this.requestToModel(request), "templates/mwf-gitlab-issue.vm");
    }

    private String processRequests(String url, GitHubConfiguration configuration) {
        GitHubRestClient githubClient = this.getGitHubAPI(url, configuration);
        String owner = ((GitHubLinkHelper)this.linkHelper).getOwner(url);
        String repo = ((GitHubLinkHelper)this.linkHelper).getRepo(url);
        String parameters = ((GitHubLinkHelper)this.linkHelper).getParameters(url);
        List<PullRequest> mergeRequests = githubClient.getPullRequests(owner, repo, parameters);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("issues", mergeRequests.stream().map(this::requestToModel).collect(Collectors.toList()));
        return this.render(model, "templates/mwf-gitlab-issues.vm");
    }

    private Map<String, Object> requestToModel(PullRequest pullRequest) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", pullRequest.getNumber());
        model.put("createdAt", pullRequest.getCreatedAt());
        model.put("title", pullRequest.getTitle());
        model.put("author", pullRequest.getUser() == null ? "" : pullRequest.getUser().getLogin());
        model.put("url", pullRequest.getHtmlUrl());
        return model;
    }
}

