/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.github.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.common.processor.AbstractLinkProcessor;
import com.moveworkforward.confluence.common.processor.Processor;
import com.moveworkforward.confluence.github.GitHubRestClient;
import com.moveworkforward.confluence.github.link.GitHubLinkHelper;
import com.moveworkforward.confluence.github.model.GitHubConfiguration;
import com.moveworkforward.confluence.github.service.GitHubConfigurationService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGitHubLinkProcessor
extends AbstractLinkProcessor<GitHubLinkHelper, GitHubConfiguration>
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(AbstractGitHubLinkProcessor.class);

    public AbstractGitHubLinkProcessor(GitHubConfigurationService configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider, GitHubLinkHelper linkHelper) {
        super(configurationService, renderer, i18nResolver, webResourceUrlProvider, linkHelper);
    }

    @Override
    protected boolean isTokenNotDefined(GitHubConfiguration configuration) {
        return configuration == null || StringUtils.isBlank((CharSequence)configuration.getPersonalAccessToken());
    }

    protected GitHubRestClient getGitHubAPI(String url, GitHubConfiguration configuration) {
        return new GitHubRestClient(((GitHubLinkHelper)this.linkHelper).getBaseUrl(url), configuration.getPersonalAccessToken());
    }
}

