/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.common.service;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.moveworkforward.ao.PluginSettingRepository;
import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.confluence.common.service.MacroConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractConfigurationService<T extends PluginEntity>
implements MacroConfigurationService<T> {
    public static final String TOKEN_MASK = "XXXXXXXXX";
    public static boolean CHECK_PERMISSIONS = true;
    public static boolean DO_NOT_CHECK_PERMISSIONS = false;
    protected final PluginSettingRepository<T> configurationRepository;
    protected final PermissionManager permissionManager;

    @Autowired
    public AbstractConfigurationService(PluginSettingRepository<T> configurationRepository, @ComponentImport PermissionManager permissionManager) {
        this.configurationRepository = configurationRepository;
        this.permissionManager = permissionManager;
    }

    @Override
    public T get() {
        return this.get(DO_NOT_CHECK_PERMISSIONS);
    }

    public T get(boolean checkPermissions) {
        if (checkPermissions) {
            this.checkAdminPermissions();
        }
        PluginEntity configuration = (PluginEntity)this.configurationRepository.getAll().stream().findFirst().orElse(this.getDefaultConfiguration());
        return (T)configuration;
    }

    public abstract T getDefaultConfiguration();

    public T delete() {
        this.checkAdminPermissions();
        T saved = this.get();
        if (saved.getId() != null) {
            return (T)this.configurationRepository.delete(saved.getId().intValue());
        }
        return null;
    }

    public T save(T entity) {
        this.checkAdminPermissions();
        this.validate(entity);
        T saved = this.get();
        if (saved.getId() != null) {
            entity.setId(saved.getId());
        }
        this.processMask(entity, saved);
        return (T)this.configurationRepository.save(entity);
    }

    protected abstract void processMask(T var1, T var2);

    protected void validate(T configuration) {
    }

    protected void checkAdminPermissions() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator((User)confluenceUser)) {
            throw new RuntimeException("User doesn't have permissions");
        }
    }
}

