/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.common.processor;

import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.common.link.LinkHelper;
import com.moveworkforward.confluence.common.processor.DefaultProcessor;
import com.moveworkforward.confluence.common.processor.Processor;
import com.moveworkforward.confluence.common.service.MacroConfigurationService;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLinkProcessor<K extends LinkHelper, T>
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(AbstractLinkProcessor.class);
    protected final TemplateRenderer renderer;
    protected final I18nResolver i18nResolver;
    protected final WebResourceUrlProvider webResourceUrlProvider;
    protected final K linkHelper;
    protected final MacroConfigurationService<T> configurationService;

    public AbstractLinkProcessor(MacroConfigurationService<T> configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider, K linkHelper) {
        this.configurationService = configurationService;
        this.renderer = renderer;
        this.i18nResolver = i18nResolver;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.linkHelper = linkHelper;
    }

    @Override
    public boolean canProcess(Map<String, String> parameters) {
        String url = this.getUrl(parameters);
        return this.linkHelper.isAccepted(url);
    }

    @Override
    public String process(Map<String, String> parameters) {
        String url = this.getUrl(parameters);
        T configuration = this.configurationService.get();
        if (this.isTokenNotDefined(configuration)) {
            return this.renderNoToken(url);
        }
        try {
            return this.doProcess(parameters, configuration);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return this.renderNoToken(url);
        }
    }

    protected abstract boolean isTokenNotDefined(T var1);

    protected abstract String doProcess(Map<String, String> var1, T var2);

    protected String renderNoToken(String url) {
        String result = DefaultProcessor.getRawLink(url) + String.format(" <span style=\"background: #feebe6\">(<a href=\"%1$s/admin/azure-devops-for-confluence.action\" target=\"_blank\" >%2$s</a>)</span>", this.getBaseUrl(), this.i18nResolver.getText("com.moveworkforward.confluence.azure-devops-confluence.invalid.token"));
        log.debug("Setup page link: {}", (Object)result);
        return result;
    }

    protected String render(Map<String, Object> model, String template) {
        try {
            log.debug("Model for rendering: {}", model);
            StringWriter stringWriter = new StringWriter();
            this.renderer.render(template, model, (Writer)stringWriter);
            stringWriter.flush();
            stringWriter.close();
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "Can't render";
        }
    }

    protected String getBaseUrl() {
        return this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
    }
}

