(function ($) {

    var AzureSearchMacro = function () {
    };

    var globalSetting;
    var selectedFields = ["System.WorkItemType", "System.Title", "System.State", "System.AssignedTo"];

    AzureSearchMacro.prototype.fields = {
        "enum": {
            "fields": function (param, options) {
                    selectedFields = ["System.WorkItemType", "System.Title", "System.State", "System.AssignedTo"];
                    var parameterField = AJS.MacroBrowser.ParameterFields["enum"](param, options);
                    var select = $(parameterField.input);
                    select.attr("multiple", true);
                    select = select.auiSelect2({sorter: function(e) {console.log(e); return e;}});
                    select.val([]).change();

                    //needed to keep order
                    select.on('select2-selecting', function(e){
                          var id = e.object.id;
                          var option = $(e.target).children('[value="'+id+'"]');
                          option.detach();
                          $(e.target).append(option).change();
                    });
                    //default fields
                    select.append($("<option></option>").val("System.WorkItemType").html("Work Item Type"));
                    select.append($("<option></option>").val("System.Title").html("Title"));
                    select.append($("<option></option>").val("System.State").html("State"));
                    select.append($("<option></option>").val("System.AssignedTo").html("Assigned To"));

                    select.val(selectedFields).change();
                    return parameterField;
                }
        },
        "string": {
            "url": function (param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["string"](param, options);
                //all macros except azure-devops-search-work-item require URL
                if(param['macroName'] === 'azure-devops-search-work-items') {
                    checkGlobalSettings(function (configuration) {
                        if (configuration.configuration.useBaseUrl) {
                           parameterField.setValue(configuration.configuration["baseUrl"]);
                           parameterField.paramDiv.hide();
                        }
                    });
                }
                parameterField.input.change(function(e) {
                    var organization = AJS.$("#macro-param-organization").val();
                    var project = AJS.$("#macro-param-project").val();
                    loadFields(AJS.$(e.target).val(), organization, project);
                });
                return parameterField;
            },
            "organization": function (param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["string"](param, options);
                //all macros except azure-devops-search-work-item require URL
                if(param['macroName'] === 'azure-devops-search-work-items') {
                   checkGlobalSettings(function (configuration) {
                      if (configuration.configuration.useOrganization) {
                         parameterField.setValue(configuration.configuration["organization"]);
                         parameterField.paramDiv.hide();
                      }
                   });
                }
                parameterField.input.change(function(e) {
                    var url = AJS.$("#macro-param-url").val();
                    var project = AJS.$("#macro-param-project").val();
                    loadFields(url, AJS.$(e.target).val(), project);
                });
                return parameterField;
            },
            "project": function (param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["string"](param, options);
                parameterField.input.change(function(e) {
                    var url = AJS.$("#macro-param-url").val();
                    var organization = AJS.$("#macro-param-organization").val();
                    loadFields(url, organization, AJS.$(e.target).val());
                });
                return parameterField;
            }
        }
    };

    //needed for Fields serialization, all parameters should be a string not a List
    AzureSearchMacro.prototype.beforeParamsRetrieved = function (parameters, macro, sharedParameters) {
        if(Array.isArray(parameters["fields"])) {
            parameters["fields"] = parameters["fields"].filter(function(f) { return typeof f !== 'undefined' && f !== '' }).join(",");
        } else {
            parameters["fields"] = "";
        }

        return parameters;
    }

    //deserialization of the fields
    AzureSearchMacro.prototype.beforeParamsSet = function (selectedParams, macroSelected) {
            if(selectedParams.hasOwnProperty('fields')){
                selectedFields = selectedParams.fields.split(",");
                selectedParams.fields = selectedFields;
            } else {
                selectedParams.fields = selectedFields
            }
            loadFields(selectedParams.url, selectedParams.organization, selectedParams.project);
            return selectedParams;
        };

    function checkGlobalSettings(action) {
       if(typeof globalSetting === 'undefined') {
          AJS.$.ajax({
             async: false,
             url: AJS.contextPath() + "/rest/azure-devops/1.0/configurations",
             dataType: 'json',
             timeout: 10000,
             error: function (xhr, textStatus, errorThrown) {
                AJS.logError(errorThrown);
                console.error("Error on fetching azure configuration: " + errorThrown);
             },
             success: function (response) {
                globalSetting = response;
                action(globalSetting);
             }
          });
       } else {
          action(globalSetting);
       }
    }

    function loadFields(url, organization, project) {
        var data = {
            'key': AJS.$("input.macro-name").val(),
            'parameters': {
                'url': url,
                'organization': organization,
                'project': project
            }
        };

        var fieldsSelect = AJS.$("#macro-param-fields");

        AJS.$.ajax({
            async: false,
            url: AJS.contextPath() + "/rest/azure-devops/1.0/work-items/fields",
            type: "POST",
            data: JSON.stringify(data),
            dataType: 'json',
            contentType: 'application/json',
            timeout: 5000,
            error: function (xhr, textStatus, errorThrown) {
                AJS.logError(errorThrown);
                console.error("Error on fetching azure configuration: " + errorThrown);
            },
            success: function (response) {
                fieldsSelect.empty();
                var selectedOptions = [];
                selectedFields.forEach(function(selectedKey) {
                    for (const [key, value] of Object.entries(response)) {
                        if(selectedKey == key) {
                            selectedOptions.push($("<option></option>").val(key).html(value));
                        }
                    }
                });

                for (const [key, value] of Object.entries(response)) {
                    if(!selectedFields.includes(key)) {
                        fieldsSelect.append($("<option></option>").val(key).html(value));
                    }
                }
                //selected options should be at the end to keep order
                selectedOptions.forEach(function(option) {
                   fieldsSelect.append(option);
                });
                fieldsSelect.val(selectedFields).change();
            }
        });

    }

    AJS.MacroBrowser.setMacroJsOverride("azure-devops-search-work-items", new AzureSearchMacro());
    AJS.MacroBrowser.setMacroJsOverride("azure-devops-work-item-link", new AzureSearchMacro());
    AJS.MacroBrowser.setMacroJsOverride("azure-devops-link", new AzureSearchMacro());
    AJS.MacroBrowser.setMacroJsOverride("azure-devops-query-link", new AzureSearchMacro());

})(AJS.$);
