/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.gitlab.service;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.moveworkforward.confluence.common.service.AbstractConfigurationService;
import com.moveworkforward.confluence.gitlab.ao.GitlabConfigurationRepository;
import com.moveworkforward.confluence.gitlab.model.GitlabConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitlabConfigurationService
extends AbstractConfigurationService<GitlabConfiguration> {
    @Autowired
    public GitlabConfigurationService(GitlabConfigurationRepository configurationRepository, @ComponentImport PermissionManager permissionManager) {
        super(configurationRepository, permissionManager);
    }

    @Override
    public GitlabConfiguration getDefaultConfiguration() {
        return new GitlabConfiguration();
    }

    @Override
    protected void validate(GitlabConfiguration configuration) {
        if (StringUtils.isBlank((CharSequence)configuration.getApiKey())) {
            throw new RuntimeException("Personal access token must be specified");
        }
    }

    @Override
    protected void processMask(GitlabConfiguration newConfiguration, GitlabConfiguration existingConfiguration) {
        if ("XXXXXXXXX".equals(newConfiguration.getApiKey())) {
            newConfiguration.setApiKey(existingConfiguration.getApiKey());
        }
    }
}

