/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.gitlab.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.gitlab.GitlabClient;
import com.moveworkforward.confluence.gitlab.link.GitlabLinkHelper;
import com.moveworkforward.confluence.gitlab.link.IssueLinkHelper;
import com.moveworkforward.confluence.gitlab.model.GitlabConfiguration;
import com.moveworkforward.confluence.gitlab.processor.AbstractGitlabLinkProcessor;
import com.moveworkforward.confluence.gitlab.service.GitlabConfigurationService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gitlab.api.models.GitlabIssue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="gitLabIssueProcessor")
public class IssueProcessor
extends AbstractGitlabLinkProcessor {
    private static final Logger log = LoggerFactory.getLogger(IssueProcessor.class);

    @Autowired
    public IssueProcessor(GitlabConfigurationService configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(configurationService, renderer, i18nResolver, webResourceUrlProvider, new IssueLinkHelper());
    }

    @Override
    protected String doProcess(Map<String, String> parameters, GitlabConfiguration configuration) {
        String url = this.getUrl(parameters);
        String id = ((GitlabLinkHelper)this.linkHelper).getId(url);
        if (StringUtils.isBlank((CharSequence)id)) {
            return this.processIssues(url, configuration);
        }
        return this.processIssue(url, configuration);
    }

    private String processIssues(String url, GitlabConfiguration configuration) {
        GitlabClient gitlabClient = this.getGitlabAPI(url, configuration);
        String projectId = ((GitlabLinkHelper)this.linkHelper).getProjectId(url);
        String parameters = ((GitlabLinkHelper)this.linkHelper).getParameters(url);
        List<GitlabIssue> issues = gitlabClient.getIssues(projectId, parameters);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("issues", issues.stream().map(issue -> this.issueToModel((GitlabIssue)issue, ((GitlabLinkHelper)this.linkHelper).getUrlWithoutParameters(url) + "/" + issue.getIid())).collect(Collectors.toList()));
        return this.render(model, "templates/mwf-gitlab-issues.vm");
    }

    private String processIssue(String url, GitlabConfiguration configuration) {
        GitlabClient gitlabClient = this.getGitlabAPI(url, configuration);
        String id = ((GitlabLinkHelper)this.linkHelper).getId(url);
        String projectId = ((GitlabLinkHelper)this.linkHelper).getProjectId(url);
        GitlabIssue issue = gitlabClient.getIssue(projectId, Integer.parseInt(id));
        return this.render(this.issueToModel(issue, url), "templates/mwf-gitlab-issue.vm");
    }

    private Map<String, Object> issueToModel(GitlabIssue issue, String url) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", issue.getIid());
        model.put("createdAt", issue.getCreatedAt());
        model.put("title", issue.getTitle());
        model.put("author", issue.getAuthor().getName());
        model.put("url", url);
        return model;
    }
}

