/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.gitlab.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.common.processor.AbstractLinkProcessor;
import com.moveworkforward.confluence.common.processor.Processor;
import com.moveworkforward.confluence.gitlab.GitlabClient;
import com.moveworkforward.confluence.gitlab.link.GitlabLinkHelper;
import com.moveworkforward.confluence.gitlab.model.GitlabConfiguration;
import com.moveworkforward.confluence.gitlab.service.GitlabConfigurationService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGitlabLinkProcessor
extends AbstractLinkProcessor<GitlabLinkHelper, GitlabConfiguration>
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(AbstractGitlabLinkProcessor.class);

    public AbstractGitlabLinkProcessor(GitlabConfigurationService configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider, GitlabLinkHelper linkHelper) {
        super(configurationService, renderer, i18nResolver, webResourceUrlProvider, linkHelper);
    }

    @Override
    protected boolean isTokenNotDefined(GitlabConfiguration configuration) {
        return configuration == null || StringUtils.isBlank((CharSequence)configuration.getApiKey());
    }

    protected GitlabClient getGitlabAPI(String url, GitlabConfiguration configuration) {
        return new GitlabClient(((GitlabLinkHelper)this.linkHelper).getBaseUrl(url), configuration);
    }
}

