/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.github.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.github.GitHubRestClient;
import com.moveworkforward.confluence.github.link.GitHubLinkHelper;
import com.moveworkforward.confluence.github.link.IssueLinkHelper;
import com.moveworkforward.confluence.github.model.GitHubConfiguration;
import com.moveworkforward.confluence.github.model.Issue;
import com.moveworkforward.confluence.github.processor.AbstractGitHubLinkProcessor;
import com.moveworkforward.confluence.github.service.GitHubConfigurationService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="gitHubIssueProcessor")
public class IssueProcessor
extends AbstractGitHubLinkProcessor {
    private static final Logger log = LoggerFactory.getLogger(IssueProcessor.class);

    @Autowired
    public IssueProcessor(GitHubConfigurationService configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(configurationService, renderer, i18nResolver, webResourceUrlProvider, new IssueLinkHelper());
    }

    @Override
    protected String doProcess(Map<String, String> parameters, GitHubConfiguration configuration) {
        String url = this.getUrl(parameters);
        String id = ((GitHubLinkHelper)this.linkHelper).getId(url);
        if (StringUtils.isBlank((CharSequence)id)) {
            return this.processIssues(url, configuration);
        }
        return this.processIssue(url, configuration);
    }

    private String processIssues(String url, GitHubConfiguration configuration) {
        GitHubRestClient githubClient = this.getGitHubAPI(url, configuration);
        String owner = ((GitHubLinkHelper)this.linkHelper).getOwner(url);
        String repo = ((GitHubLinkHelper)this.linkHelper).getRepo(url);
        String parameters = ((GitHubLinkHelper)this.linkHelper).getParameters(url);
        List<Issue> issues = githubClient.getIssues(owner, repo, parameters);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("issues", issues.stream().map(this::issueToModel).collect(Collectors.toList()));
        return this.render(model, "templates/mwf-gitlab-issues.vm");
    }

    private String processIssue(String url, GitHubConfiguration configuration) {
        GitHubRestClient githubClient = this.getGitHubAPI(url, configuration);
        String id = ((GitHubLinkHelper)this.linkHelper).getId(url);
        String owner = ((GitHubLinkHelper)this.linkHelper).getOwner(url);
        String repo = ((GitHubLinkHelper)this.linkHelper).getRepo(url);
        Issue issue = githubClient.getIssue(owner, repo, Integer.parseInt(id));
        return this.render(this.issueToModel(issue), "templates/mwf-gitlab-issue.vm");
    }

    private Map<String, Object> issueToModel(Issue issue) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", issue.getNumber());
        model.put("createdAt", issue.getCreatedAt());
        model.put("title", issue.getTitle());
        model.put("author", issue.getUser() == null ? "" : issue.getUser().getLogin());
        model.put("url", issue.getHtmlUrl());
        return model;
    }
}

