/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.github;

import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.github.model.Issue;
import com.moveworkforward.confluence.github.model.PullRequest;
import com.moveworkforward.util.ConnectorUtil;
import java.net.URLDecoder;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubRestClient {
    private static final Logger log = LoggerFactory.getLogger(GitHubRestClient.class);
    public static final int DEFAULT_LIMIT = 10;
    private final ObjectMapper objectMapper = ConnectorUtil.createObjectMapper((boolean)true);
    private final String baseUrl;
    private final String accessToken;

    public GitHubRestClient(String baseUrl, String accessToken) {
        this.baseUrl = baseUrl;
        this.accessToken = accessToken;
    }

    public Issue getIssue(String owner, String repo, int issueId) {
        String url = this.baseUrl + String.format("/repos/%s/%s/issues/%s", owner, repo, issueId);
        return this.getEntity(url, this.accessToken, new TypeReference<Issue>(){});
    }

    public List<Issue> getIssues(String owner, String repo, String parameters) {
        String url = this.baseUrl + String.format("/repos/%s/%s/issues?%s", owner, repo, this.parseParameters(parameters));
        return this.getEntity(url, this.accessToken, new TypeReference<List<Issue>>(){}).stream().filter(issue -> MapUtils.isEmpty(issue.getPullRequest())).collect(Collectors.toList());
    }

    private String parseParameters(String parameters) {
        parameters = URLDecoder.decode(parameters);
        String state = "open";
        if (parameters.contains("is:closed")) {
            state = "closed";
        } else if (parameters.contains("is:all")) {
            state = "all";
        }
        return "state=" + state;
    }

    public List<PullRequest> getPullRequests(String owner, String repo, String parameters) {
        String url = this.baseUrl + String.format("/repos/%s/%s/pulls?%s", owner, repo, this.parseParameters(parameters));
        return this.getEntity(url, this.accessToken, new TypeReference<List<PullRequest>>(){});
    }

    public PullRequest getPullRequest(String owner, String repo, int requestId) {
        String url = this.baseUrl + String.format("/repos/%s/%s/pulls/%s", owner, repo, requestId);
        return this.getEntity(url, this.accessToken, new TypeReference<PullRequest>(){});
    }

    private <T> T getEntity(String url, String token, TypeReference<T> clazz) {
        return this.executeRequest(url, token, (HttpRequestBase)new HttpGet(url), clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeRequest(String url, String token, HttpRequestBase request, TypeReference<T> clazz) {
        try {
            log.debug("URL: {}", (Object)url);
            try (CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setRetryHandler((HttpRequestRetryHandler)new AzureRestClient.RetryHandler()).build();){
                String authHeader = "token " + token;
                request.setHeader("Authorization", authHeader);
                request.setHeader("Accept", "application/vnd.github.v3+json");
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                int statusCode = response.getStatusLine().getStatusCode();
                log.debug("Status code: {}", (Object)statusCode);
                log.debug("Content: {}", (Object)content);
                if (statusCode > 300) {
                    log.error("Status code: {}", (Object)statusCode);
                    log.error("Response: \n{}", (Object)content);
                    T t = null;
                    return t;
                }
                Object object = this.objectMapper.readValue(content, clazz);
                return (T)object;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

