/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.link;

import com.moveworkforward.confluence.azure.link.AbstractLinkHelper;
import java.util.Arrays;
import java.util.List;

public class PipelineLinkHelper
extends AbstractLinkHelper {
    private static final String BUILD = "_build?definitionId=";

    @Override
    public String getKeyPath() {
        return BUILD;
    }

    @Override
    public String getId(String url) {
        List<String> parts = PipelineLinkHelper.splitUrl(url);
        int buildIndex = this.getKeyPathIndex(parts);
        return parts.get(buildIndex).replace(this.getKeyPath(), "");
    }

    @Override
    public int getKeyPathIndex(List<String> parts) {
        for (int i = 0; i < parts.size(); ++i) {
            if (!parts.get(i).startsWith(this.getKeyPath())) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected boolean isUrlAccepted(List<String> parts, int expectedIndex) {
        int index = this.getKeyPathIndex(parts);
        return Arrays.asList("http:", "https:").contains(parts.get(0)) && index >= expectedIndex && parts.size() > index;
    }
}

