/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.link;

import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLinkHelper
implements AzureLinkHelper {
    private static final Logger log = LoggerFactory.getLogger(AbstractLinkHelper.class);
    private static final String OLD_API_DOMAIN = "visualstudio.com";

    @Override
    public String getBaseUrl(String url) {
        try {
            List<String> parts = AbstractLinkHelper.splitUrl(url);
            return this.isOldApi(parts) ? this.getOldBaseUrl(parts) : this.getNewBaseUrl(parts);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public abstract String getKeyPath();

    private String getNewBaseUrl(List<String> parts) {
        int index = this.getKeyPathIndex(parts);
        return String.join((CharSequence)"/", parts.subList(0, index - 2));
    }

    private String getOldBaseUrl(List<String> parts) {
        return "https://dev.azure.com";
    }

    @Override
    public String getOrganizationID(String url) {
        List<String> parts = AbstractLinkHelper.splitUrl(url);
        int index = this.getKeyPathIndex(parts);
        return this.isOldApi(parts) ? parts.get(2).split("\\.")[0] : parts.get(index - 2);
    }

    @Override
    public String getProjectName(String url) {
        List<String> parts = AbstractLinkHelper.splitUrl(url);
        int index = this.getKeyPathIndex(parts);
        return parts.get(index - 1);
    }

    @Override
    public String getId(String url) {
        List<String> parts = AbstractLinkHelper.splitUrl(url);
        int queryIndex = this.getKeyPathIndex(parts);
        return parts.get(queryIndex + 2);
    }

    protected static List<String> splitUrl(String url) {
        return Arrays.asList(url.split("/"));
    }

    public int getKeyPathIndex(List<String> parts) {
        return parts.indexOf(this.getKeyPath());
    }

    @Override
    public boolean isAccepted(String url) {
        List<String> parts = AbstractLinkHelper.splitUrl(url);
        if (this.isOldApi(parts)) {
            return this.isOldUrlAccepted(parts);
        }
        return this.isNewUrlAccepted(parts);
    }

    private boolean isOldApi(List<String> parts) {
        return parts.get(2).endsWith(OLD_API_DOMAIN);
    }

    private boolean isOldUrlAccepted(List<String> parts) {
        return this.isUrlAccepted(parts, 4);
    }

    private boolean isNewUrlAccepted(List<String> parts) {
        return this.isUrlAccepted(parts, 5);
    }

    protected boolean isUrlAccepted(List<String> parts, int expectedIndex) {
        int index = this.getKeyPathIndex(parts);
        return Arrays.asList("http:", "https:").contains(parts.get(0)) && index >= expectedIndex && parts.size() > index + 2;
    }
}

