/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.component;

import com.moveworkforward.confluence.azure.model.BuildStatusResponse;
import com.moveworkforward.confluence.azure.model.FieldsResponse;
import com.moveworkforward.confluence.azure.model.GeneralRequest;
import com.moveworkforward.confluence.azure.model.QueryResponse;
import com.moveworkforward.confluence.azure.model.ReleaseRequest;
import com.moveworkforward.confluence.azure.model.ReleaseResponse;
import com.moveworkforward.confluence.azure.model.ReleasesResponse;
import com.moveworkforward.confluence.azure.model.SearchRequest;
import com.moveworkforward.confluence.azure.model.SearchResponse;
import com.moveworkforward.confluence.azure.model.WorkItemResponse;
import com.moveworkforward.util.ConnectorUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AzureRestClient {
    private static final Logger log = LoggerFactory.getLogger(AzureRestClient.class);
    private static final int ATTEMPTS_COUNT = 3;
    private final ObjectMapper objectMapper = ConnectorUtil.createObjectMapper((boolean)true);

    public FieldsResponse getFields(String baseUrl, String token, GeneralRequest request) {
        String organizationProjectContext = this.preparePathValue(request.getOrganizationId()) + (StringUtils.isBlank((CharSequence)request.getProjectName()) ? "" : "/" + this.preparePathValue(request.getProjectName()));
        String url = String.format("%s/%s/_apis/wit/fields", baseUrl, organizationProjectContext);
        FieldsResponse fieldsResponse = this.getEntity(url, token, FieldsResponse.class);
        fieldsResponse.getValue().removeIf(field -> !"workItem".equals(field.getUsage()));
        return fieldsResponse;
    }

    public WorkItemResponse getWorkItem(String baseUrl, String token, GeneralRequest workItemRequest) {
        String url = String.format("%s/%s/%s/_apis/wit/workitems/%s", baseUrl, workItemRequest.getOrganizationId(), workItemRequest.getProjectName(), workItemRequest.getId());
        return this.getEntity(url, token, WorkItemResponse.class);
    }

    private <T> T getEntity(String url, String token, Class<T> clazz) {
        return this.executeRequest(url, token, (HttpRequestBase)new HttpGet(url), clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeRequest(String url, String token, HttpRequestBase request, Class<T> clazz) {
        CloseableHttpResponse response = null;
        try {
            log.debug("URL: {}", (Object)url);
            try (CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().setRetryHandler((HttpRequestRetryHandler)new RetryHandler()).build();){
                String auth = ":" + token;
                byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
                String authHeader = "Basic " + new String(encodedAuth);
                request.setHeader("Authorization", authHeader);
                response = client.execute((HttpUriRequest)request);
                String content = EntityUtils.toString((HttpEntity)response.getEntity());
                int statusCode = response.getStatusLine().getStatusCode();
                log.debug("Status code: {}", (Object)statusCode);
                log.debug("Content: {}", (Object)content);
                if (statusCode > 300 && statusCode < 400) {
                    T t = this.redirect(url, (HttpResponse)response, token, request, clazz);
                    return t;
                }
                if (statusCode > 400) {
                    this.logErrorResponse(url, (HttpResponse)response);
                    T t = null;
                    return t;
                }
                Object object = this.objectMapper.readValue(content, clazz);
                return (T)object;
            }
        }
        catch (Exception e) {
            this.logErrorResponse(url, (HttpResponse)response);
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private <T> T redirect(String url, HttpResponse response, String token, HttpRequestBase request, Class<T> clazz) {
        log.warn("Resource was moved from {}, trying to reach it out", (Object)url);
        Header header = null;
        if (response.containsHeader("Location")) {
            header = response.getFirstHeader("Location");
        } else if (response.containsHeader("location")) {
            header = response.getFirstHeader("location");
        }
        if (header == null || StringUtils.isBlank((CharSequence)header.getValue())) {
            this.logErrorResponse(url, response);
            return null;
        }
        if (url.equals(header.getValue())) {
            log.error("Redirection to the same url: {}", (Object)url);
            return null;
        }
        url = header.getValue();
        log.warn("New resource location is {}", (Object)url);
        request.setURI(URI.create(url));
        return this.executeRequest(url, token, request, clazz);
    }

    private void logErrorResponse(String url, HttpResponse response) {
        if (response == null) {
            log.error("Response is empty for url: {}", (Object)url);
        } else {
            String content = EntityUtils.toString((HttpEntity)response.getEntity());
            int statusCode = response.getStatusLine().getStatusCode();
            log.error("Error while getting content from url {}", (Object)url);
            log.error("Status code: {}", (Object)statusCode);
            log.error("Response: \n{}", (Object)content);
        }
    }

    public <T> T postEntity(String url, String token, Object payload, Class<T> clazz) {
        try {
            HttpPost request = new HttpPost(url);
            request.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            byte[] payloadBytes = payload instanceof String ? ((String)payload).getBytes(StandardCharsets.UTF_8) : this.objectMapper.writeValueAsBytes(payload);
            request.setEntity((HttpEntity)new ByteArrayEntity(payloadBytes));
            return this.executeRequest(url, token, (HttpRequestBase)request, clazz);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public SearchResponse searchItems(String baseUrl, String token, SearchRequest searchRequest) {
        String organizationProjectContext = this.preparePathValue(searchRequest.getOrganizationId()) + (StringUtils.isBlank((CharSequence)searchRequest.getProjectName()) ? "" : "/" + this.preparePathValue(searchRequest.getProjectName()));
        String url = String.format("%s/%s/_apis/wit/wiql?timePrecision=true&api-version=6.0", baseUrl, organizationProjectContext);
        if (searchRequest.getLimit() != null && searchRequest.getLimit() > 0) {
            url = url + "&$top=" + searchRequest.getLimit();
        }
        log.info("Query: {}", (Object)searchRequest.getQuery());
        SearchResponse searchResponse = this.postEntity(url, token, searchRequest, SearchResponse.class);
        if (searchResponse == null) {
            return null;
        }
        List<WorkItemResponse> workItemResponses = searchResponse.getWorkItems().stream().map(w -> this.getEntity(w.getUrl(), token, WorkItemResponse.class)).collect(Collectors.toList());
        searchResponse.setWorkItems(workItemResponses);
        return searchResponse;
    }

    public QueryResponse getQuery(String baseUrl, String token, GeneralRequest queryRequest) {
        String url = String.format("%s/%s/%s/_apis/wit/queries/%s", baseUrl, queryRequest.getOrganizationId(), queryRequest.getProjectName(), queryRequest.getId());
        QueryResponse queryResponse = this.getEntity(url, token, QueryResponse.class);
        if (queryResponse == null) {
            return null;
        }
        Map queryResult = this.getEntity(queryResponse.getLinks().getWiql().getHref(), token, Map.class);
        ArrayList<Map> workitemMaps = (ArrayList<Map>)queryResult.get("workItems");
        if (workitemMaps == null) {
            if (queryResult.containsKey("workItemRelations")) {
                workitemMaps = new ArrayList<Map>();
                List workItemRelations = (List)queryResult.get("workItemRelations");
                for (Map workItemRelation : workItemRelations) {
                    Map workItem = (Map)workItemRelation.get("source");
                    if (workItem != null) {
                        workitemMaps.add(workItem);
                    }
                    if ((workItem = (Map)workItemRelation.get("target")) == null) continue;
                    workitemMaps.add(workItem);
                }
            } else {
                throw new RuntimeException("Unsupported type of query");
            }
        }
        LinkedHashSet workitemSet = new LinkedHashSet(workitemMaps);
        List workItemResponses = workitemSet.stream().map(m -> this.getEntity((String)m.get("url"), token, WorkItemResponse.class)).collect(Collectors.toList());
        queryResponse.setWorkItems(new ArrayList<WorkItemResponse>(new LinkedHashSet(workItemResponses)));
        return queryResponse;
    }

    public BuildStatusResponse getBuildStatus(String baseUrl, String token, GeneralRequest buildsRequest) {
        String url = String.format("%s/%s/%s/_apis/build/Builds?definitions=%s&maxBuildsPerDefinition=1", baseUrl, buildsRequest.getOrganizationId(), buildsRequest.getProjectName(), buildsRequest.getId());
        BuildStatusResponse response = this.getEntity(url, token, BuildStatusResponse.class);
        if (response != null && CollectionUtils.isNotEmpty(response.getValue())) {
            for (BuildStatusResponse.BuildStatus buildStatus : response.getValue()) {
                buildStatus.setProject(this.getEntity(buildStatus.getProject().getUrl(), token, BuildStatusResponse.Project.class));
                buildStatus.setDefinition(this.getEntity(buildStatus.getDefinition().getUrl(), token, BuildStatusResponse.Definition.class));
            }
        }
        return response;
    }

    public ReleasesResponse getReleases(String baseUrl, String token, ReleaseRequest request) {
        String url = String.format("%s/%s/%s/_apis/release/releases?$expand=environments&definitionId=%s", baseUrl, request.getOrganizationId(), request.getProjectName(), request.getId());
        if (request.getLimit() != null) {
            url = url + "&$top=" + request.getLimit();
        }
        ReleasesResponse response = this.getEntity(url, token, ReleasesResponse.class);
        return response;
    }

    public ReleaseResponse getRelease(String baseUrl, String token, GeneralRequest request) {
        String url = String.format("%s/%s/%s/_apis/Release/releases/%s", baseUrl, request.getOrganizationId(), request.getProjectName(), request.getId());
        ReleaseResponse response = this.getEntity(url, token, ReleaseResponse.class);
        return response;
    }

    private String preparePathValue(String value) {
        return StringUtils.isNotBlank((CharSequence)value) && value.contains(" ") ? URIUtil.encodePath((String)value) : value;
    }

    public static class RetryHandler
    extends DefaultHttpRequestRetryHandler {
        public RetryHandler() {
            super(3, true, Collections.emptyList());
        }
    }
}

