/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.gitlab.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.gitlab.GitlabClient;
import com.moveworkforward.confluence.gitlab.link.GitlabLinkHelper;
import com.moveworkforward.confluence.gitlab.link.MergeRequestLinkHelper;
import com.moveworkforward.confluence.gitlab.model.GitlabConfiguration;
import com.moveworkforward.confluence.gitlab.processor.AbstractGitlabLinkProcessor;
import com.moveworkforward.confluence.gitlab.service.GitlabConfigurationService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gitlab.api.models.GitlabMergeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MergeRequestProcessor
extends AbstractGitlabLinkProcessor {
    private static final Logger log = LoggerFactory.getLogger(MergeRequestProcessor.class);

    @Autowired
    public MergeRequestProcessor(GitlabConfigurationService configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(configurationService, renderer, i18nResolver, webResourceUrlProvider, new MergeRequestLinkHelper());
    }

    @Override
    protected String doProcess(Map<String, String> parameters, GitlabConfiguration configuration) {
        String url = this.getUrl(parameters);
        String id = ((GitlabLinkHelper)this.linkHelper).getId(url);
        if (StringUtils.isBlank((CharSequence)id)) {
            return this.processRequests(url, configuration);
        }
        return this.processRequest(url, configuration);
    }

    private String processRequest(String url, GitlabConfiguration configuration) {
        GitlabClient gitlabClient = this.getGitlabAPI(url, configuration);
        String id = ((GitlabLinkHelper)this.linkHelper).getId(url);
        String projectId = ((GitlabLinkHelper)this.linkHelper).getProjectId(url);
        GitlabMergeRequest request = gitlabClient.getMergeRequest(projectId, Integer.parseInt(id));
        return this.render(this.requestToModel(request, url), "templates/mwf-gitlab-issue.vm");
    }

    private String processRequests(String url, GitlabConfiguration configuration) {
        GitlabClient gitlabClient = this.getGitlabAPI(url, configuration);
        String projectId = ((GitlabLinkHelper)this.linkHelper).getProjectId(url);
        String parameters = ((GitlabLinkHelper)this.linkHelper).getParameters(url);
        List<GitlabMergeRequest> mergeRequests = gitlabClient.getMergeRequests(projectId, parameters);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("issues", mergeRequests.stream().map(request -> this.requestToModel((GitlabMergeRequest)request, ((GitlabLinkHelper)this.linkHelper).getUrlWithoutParameters(url) + "/" + request.getIid())).collect(Collectors.toList()));
        return this.render(model, "templates/mwf-gitlab-issues.vm");
    }

    private Map<String, Object> requestToModel(GitlabMergeRequest mergeRequest, String url) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", mergeRequest.getIid());
        model.put("createdAt", mergeRequest.getCreatedAt());
        model.put("title", mergeRequest.getTitle());
        model.put("author", mergeRequest.getAuthor().getName());
        model.put("url", url);
        return model;
    }
}

