/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.gitlab;

import com.moveworkforward.confluence.gitlab.model.GitlabConfiguration;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.TokenType;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabMergeRequest;

public class GitlabClient {
    public static final int DEFAULT_LIMIT = 10;
    private final GitlabAPI gitlabAPI;

    public GitlabClient(String baseUrl, GitlabConfiguration connection) {
        this.gitlabAPI = GitlabAPI.connect((String)baseUrl, (String)connection.getApiKey(), (TokenType)connection.getTokenType());
    }

    public GitlabIssue getIssue(String projectId, int issueId) {
        return this.gitlabAPI.getIssue((Serializable)((Object)projectId), Integer.valueOf(issueId));
    }

    public List<GitlabIssue> getIssues(String projectId, String parameters) {
        String tailUrl = "/projects/" + GitlabClient.sanitizeId((Serializable)((Object)projectId)) + "/issues?" + parameters;
        return this.collect(tailUrl, GitlabIssue[].class);
    }

    public static String sanitizeId(Serializable id) {
        if (!(id instanceof String) && !(id instanceof Number)) {
            throw new IllegalArgumentException("ID needs to be of type String or Number");
        }
        try {
            return URLEncoder.encode(String.valueOf(id), "UTF-8");
        }
        catch (UnsupportedEncodingException var4) {
            throw new RuntimeException(var4);
        }
    }

    public List<GitlabMergeRequest> getMergeRequests(String projectId, String parameters) {
        String tailUrl = "/projects/" + GitlabClient.sanitizeId((Serializable)((Object)projectId)) + "/merge_requests?" + parameters;
        return this.collect(tailUrl, GitlabMergeRequest[].class);
    }

    private <T> List<T> collect(String tailUrl, Class<T[]> type) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iterator = this.gitlabAPI.retrieve().asIterator(tailUrl, type);
        block0: while (iterator.hasNext() && result.size() < 10) {
            Object[] requests = (Object[])iterator.next();
            if (requests.length <= 0) continue;
            for (Object issue : requests) {
                result.add(issue);
                if (result.size() >= 10) continue block0;
            }
        }
        return result;
    }

    public GitlabMergeRequest getMergeRequest(String projectId, int requestId) {
        return this.gitlabAPI.getMergeRequest((Serializable)((Object)projectId), Integer.valueOf(requestId));
    }
}

