/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.common;

import com.moveworkforward.ao.entity.PluginEntity;
import com.moveworkforward.confluence.common.service.AbstractConfigurationService;
import com.moveworkforward.util.ConnectorUtil;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLinkController<T extends PluginEntity>
extends TypeReference<T> {
    protected final AbstractConfigurationService<T> configurationService;
    protected ObjectMapper objectMapper = ConnectorUtil.createObjectMapper();

    @Autowired
    public AbstractLinkController(AbstractConfigurationService<T> configurationService) {
        this.configurationService = configurationService;
    }

    @GET
    public T get() {
        return this.hideToken(this.copy(this.configurationService.get(AbstractConfigurationService.CHECK_PERMISSIONS)));
    }

    @POST
    public T save(T configuration) {
        return this.hideToken(this.copy(this.configurationService.save(configuration)));
    }

    @DELETE
    public T delete() {
        return this.hideToken(this.copy(this.configurationService.delete()));
    }

    private T copy(T configuration) {
        return (T)((PluginEntity)this.objectMapper.convertValue(configuration, (TypeReference)this));
    }

    protected abstract T hideToken(T var1);
}

