/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.configuration;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class LicenseManager {
    private static final Logger log = LoggerFactory.getLogger(LicenseManager.class);
    private boolean isDevMode;
    private final PluginLicenseManager pluginLicenseManager;

    @Autowired
    public LicenseManager(@ComponentImport PluginLicenseManager pluginLicenseManager, Environment environment) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.isDevMode = (Boolean)environment.getProperty("moveworkforward.dev.mode", Boolean.class, (Object)false);
    }

    public boolean isLicensed() {
        boolean result = true;
        if (this.isDevMode) {
            log.info("Microsoft Teams Confluence Connector: License check is skipped");
        } else {
            Option license = this.pluginLicenseManager.getLicense();
            boolean bl = result = license.isDefined() && ((PluginLicense)license.get()).isValid();
        }
        if (result) {
            log.info("Azure DevOps Confluence Connector: Plugin licensed.");
        } else {
            log.error("Azure DevOps Confluence Connector: There is no valid licence");
        }
        return result;
    }
}

