/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.github.link;

import com.moveworkforward.confluence.github.link.GitHubLinkHelper;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLinkHelper
implements GitHubLinkHelper {
    private static final Logger log = LoggerFactory.getLogger(AbstractLinkHelper.class);
    private static final String SITE_API_URL = "https://api.github.com";
    private static final String ENTERPRISE_API_SUFFIX = "/api/v3";
    private static final Pattern GITHUB_URL_REGEXP = Pattern.compile("^.+github.com.*$", 2);

    @Override
    public String getBaseUrl(String targetUrl) {
        try {
            URL url = new URL(targetUrl);
            String baseUrl = url.getProtocol() + "://" + url.getHost();
            return AbstractLinkHelper.isGitHubSite(baseUrl) ? SITE_API_URL : baseUrl.trim().replaceAll("/+$", "") + ENTERPRISE_API_SUFFIX;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static boolean isGitHubSite(String serverUrl) {
        return GITHUB_URL_REGEXP.matcher(serverUrl).matches();
    }

    @Override
    public String getOwner(String url) {
        List<String> parts = this.splitUrl(this.getUrlWithoutParameters(url));
        int index = this.getKeyPathIndex(parts);
        return parts.get(index - 2);
    }

    @Override
    public String getRepo(String url) {
        List<String> parts = this.splitUrl(this.getUrlWithoutParameters(url));
        int index = this.getKeyPathIndex(parts);
        return parts.get(index - 1);
    }

    @Override
    public String getUrlWithoutParameters(String url) {
        int index = url.indexOf("?");
        if (index > 0) {
            return url.substring(0, index);
        }
        return url;
    }

    @Override
    public String getId(String url) {
        List<String> parts = this.splitUrl(this.getUrlWithoutParameters(url));
        return parts.get(parts.size() - 1).startsWith(this.getKeyPath()) ? null : parts.get(parts.size() - 1);
    }

    @Override
    public String getParameters(String url) {
        String parameters = "";
        if (url.contains("?")) {
            parameters = url.substring(url.indexOf("?") + 1);
        }
        return parameters;
    }

    @Override
    public boolean isAccepted(String url) {
        return url.contains(this.getKeyPath());
    }

    public int getKeyPathIndex(List<String> parts) {
        for (int i = 0; i < parts.size(); ++i) {
            if (!parts.get(i).startsWith(this.getKeyPath())) continue;
            return i;
        }
        return -1;
    }

    public abstract String getKeyPath();

    protected List<String> splitUrl(String url) {
        return Arrays.asList(url.split("/"));
    }
}

