/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.common.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.sal.api.message.I18nResolver;
import com.moveworkforward.confluence.azure.configuration.LicenseManager;
import com.moveworkforward.confluence.common.processor.DefaultProcessor;
import com.moveworkforward.confluence.common.processor.NoLicenseProcessor;
import com.moveworkforward.confluence.common.processor.Processor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMacro<T extends Processor>
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(AbstractMacro.class);
    protected final T mainProcessor;
    protected final LicenseManager licenseManager;
    protected final NoLicenseProcessor noLicenseProcessor;
    protected final DefaultProcessor defaultProcessor;

    protected AbstractMacro(T processor, LicenseManager licenseManager, I18nResolver i18nResolver) {
        this.mainProcessor = processor;
        this.licenseManager = licenseManager;
        this.noLicenseProcessor = new NoLicenseProcessor(i18nResolver);
        this.defaultProcessor = new DefaultProcessor();
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) {
        String url = parameters.get("url");
        try {
            Processor processor = this.getProcessor(parameters);
            String result = processor.process(parameters);
            log.debug(this.getClass().getSimpleName() + " execute result: {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return DefaultProcessor.getRawLink(url);
        }
    }

    protected Processor getProcessor(Map<String, String> parameters) {
        Processor processor = this.defaultProcessor;
        if (this.licenseManager.isLicensed()) {
            if (this.mainProcessor.canProcess(parameters)) {
                processor = this.mainProcessor;
            }
        } else {
            processor = this.noLicenseProcessor;
        }
        return processor;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }
}

