/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.link.DelegateWorkItemLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.model.GeneralRequest;
import com.moveworkforward.confluence.azure.model.WorkItemResponse;
import com.moveworkforward.confluence.azure.processor.AbstractAzureLinkProcessor;
import com.moveworkforward.confluence.azure.service.DelegateAzureDevOpsConfigurationService;
import com.moveworkforward.confluence.common.processor.Processor;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkItemLinkProcessor
extends AbstractAzureLinkProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(WorkItemLinkProcessor.class);

    @Autowired
    public WorkItemLinkProcessor(AzureRestClient azureRestClient, DelegateAzureDevOpsConfigurationService configurationService, @ComponentImport TemplateRenderer renderer, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider) {
        super(azureRestClient, configurationService, renderer, i18nResolver, webResourceUrlProvider, new DelegateWorkItemLinkHelper());
    }

    @Override
    protected String doProcess(Map<String, String> parameters, AzureConfigurationsHolder configurationsHolder) {
        String url = this.getUrl(parameters);
        boolean hideHeader = Boolean.parseBoolean(parameters.get("hideHeader"));
        String azureBaseUrl = ((AzureLinkHelper)this.linkHelper).getBaseUrl(url);
        String organizationID = ((AzureLinkHelper)this.linkHelper).getOrganizationID(url);
        String projectName = ((AzureLinkHelper)this.linkHelper).getProjectName(url);
        String workItemId = ((AzureLinkHelper)this.linkHelper).getId(url);
        GeneralRequest request = new GeneralRequest(organizationID, projectName, workItemId);
        AzureDevOpsConfiguration configuration = null;
        WorkItemResponse response = null;
        for (AzureDevOpsConfiguration currentConfiguration : configurationsHolder.getConfigurations()) {
            log.debug("Get work items using {} configuration", (Object)currentConfiguration.getLevel());
            try {
                response = this.azureRestClient.getWorkItem(azureBaseUrl, currentConfiguration.getConfiguration().getPersonalAccessToken(), request);
                if (response == null) continue;
                configuration = currentConfiguration;
                break;
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        log.debug("URL: {}, response: {}", (Object)url, response);
        if (response == null || configuration == null) {
            return this.renderNoToken(url);
        }
        Set<String> fieldsToDisplay = this.getFieldsToDisplay(parameters);
        Map<String, String> allFields = this.getAllFields(azureBaseUrl, configuration.getConfiguration().getPersonalAccessToken(), organizationID, projectName);
        Map<String, Object> model = this.workItemToModel(response);
        model.put("fieldsToDisplay", fieldsToDisplay);
        model.put("allFields", allFields);
        model.put("hideHeader", hideHeader);
        model.put("workItems", Arrays.asList(model));
        return this.render(model, "templates/mwf-ado-work-item.vm");
    }
}

