/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.azure.link.AbstractLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.AzureDevOpsConfiguration;
import com.moveworkforward.confluence.azure.model.SearchRequest;
import com.moveworkforward.confluence.azure.model.SearchResponse;
import com.moveworkforward.confluence.azure.model.WorkItemResponse;
import com.moveworkforward.confluence.azure.processor.AbstractAzureLinkProcessor;
import com.moveworkforward.confluence.azure.service.DelegateAzureDevOpsConfigurationService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchWorkItemsProcessor
extends AbstractAzureLinkProcessor {
    private static final Logger log = LoggerFactory.getLogger(SearchWorkItemsProcessor.class);

    @Autowired
    protected SearchWorkItemsProcessor(AzureRestClient azureRestClient, DelegateAzureDevOpsConfigurationService configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider) {
        super(azureRestClient, configurationService, renderer, i18nResolver, webResourceUrlProvider, new AbstractLinkHelper(){

            @Override
            public String getKeyPath() {
                return "";
            }
        });
    }

    @Override
    public boolean canProcess(Map<String, String> parameters) {
        AzureConfigurationsHolder configurationsHolder = (AzureConfigurationsHolder)this.configurationService.get();
        Iterator<AzureDevOpsConfiguration> iterator = configurationsHolder.getConfigurations().iterator();
        if (iterator.hasNext()) {
            AzureDevOpsConfiguration configuration = iterator.next();
            String url = this.getUrl(parameters, configuration);
            return url != null && url.startsWith("http") && StringUtils.isNotBlank((CharSequence)this.getOrganization(parameters, configuration)) && StringUtils.isNotBlank((CharSequence)parameters.get("searchText"));
        }
        return false;
    }

    @Override
    protected String doProcess(Map<String, String> parameters, AzureConfigurationsHolder configurationsHolder) {
        for (AzureDevOpsConfiguration configuration : configurationsHolder.getConfigurations()) {
            log.debug("Search work items using {} configuration", (Object)configuration.getLevel());
            try {
                String url = this.getUrl(parameters, configuration);
                boolean hideHeader = Boolean.parseBoolean(parameters.get("hideHeader"));
                Integer itemsCount = this.getIntegerValue(parameters, "itemsCount");
                String organizationID = this.getOrganization(parameters, configuration);
                String projectName = parameters.get("project");
                String searchText = parameters.get("searchText");
                String projectCondition = StringUtils.isBlank((CharSequence)projectName) ? "" : String.format("and [System.TeamProject] = '%1$s'", projectName);
                String query = String.format("select [System.Id] from WorkItems where ([System.Title] contains words '%1$s' or [System.Description] contains words '%1$s') %2$s order by [System.ChangedDate] desc", searchText, projectCondition);
                SearchRequest request = new SearchRequest(organizationID, projectName, query, itemsCount);
                SearchResponse response = this.azureRestClient.searchItems(url, configuration.getConfiguration().getPersonalAccessToken(), request);
                log.debug("URL: {}, response: {}", (Object)url, (Object)response);
                if (response == null) {
                    throw new RuntimeException("No response");
                }
                HashMap<String, Object> model = new HashMap<String, Object>();
                List<WorkItemResponse> workItemResponses = response.getWorkItems();
                Set<String> fieldsToDisplay = this.getFieldsToDisplay(parameters);
                Map<String, String> allFields = this.getAllFields(url, configuration.getConfiguration().getPersonalAccessToken(), organizationID, projectName);
                List workItems = workItemResponses.stream().map(this::workItemToModel).collect(Collectors.toList());
                model.put("workItems", workItems);
                model.put("searchText", searchText);
                model.put("organization", organizationID);
                model.put("project", projectName);
                model.put("fieldsToDisplay", fieldsToDisplay);
                model.put("allFields", allFields);
                model.put("hideHeader", hideHeader);
                return this.render(model, "templates/mwf-ado-search-work-items.vm");
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this.renderNoToken(parameters.getOrDefault("url", "Unknown"));
    }

    public String getUrl(Map<String, String> parameters, AzureDevOpsConfiguration configuration) {
        return configuration.getConfiguration().isUseBaseUrl() ? configuration.getConfiguration().getBaseUrl() : parameters.get("url");
    }

    public String getOrganization(Map<String, String> parameters, AzureDevOpsConfiguration configuration) {
        return configuration.getConfiguration().isUseOrganization() ? configuration.getConfiguration().getOrganization() : parameters.get("organization");
    }
}

