/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.confluence.azure.processor;

import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.moveworkforward.confluence.azure.component.AzureRestClient;
import com.moveworkforward.confluence.azure.link.AzureLinkHelper;
import com.moveworkforward.confluence.azure.model.AzureConfigurationsHolder;
import com.moveworkforward.confluence.azure.model.FieldsResponse;
import com.moveworkforward.confluence.azure.model.GeneralRequest;
import com.moveworkforward.confluence.azure.model.IconProperty;
import com.moveworkforward.confluence.azure.model.User;
import com.moveworkforward.confluence.azure.model.WorkItemResponse;
import com.moveworkforward.confluence.azure.rest.WorkItemFieldsController;
import com.moveworkforward.confluence.azure.service.DelegateAzureDevOpsConfigurationService;
import com.moveworkforward.confluence.common.processor.AbstractLinkProcessor;
import com.moveworkforward.confluence.common.processor.Processor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAzureLinkProcessor
extends AbstractLinkProcessor<AzureLinkHelper, AzureConfigurationsHolder>
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(AbstractAzureLinkProcessor.class);
    protected final AzureRestClient azureRestClient;

    protected AbstractAzureLinkProcessor(AzureRestClient azureRestClient, DelegateAzureDevOpsConfigurationService configurationService, TemplateRenderer renderer, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider, AzureLinkHelper linkHelper) {
        super(configurationService, renderer, i18nResolver, webResourceUrlProvider, linkHelper);
        this.azureRestClient = azureRestClient;
    }

    @Override
    protected boolean isTokenNotDefined(AzureConfigurationsHolder configurationsHolder) {
        return configurationsHolder == null || configurationsHolder.isEmpty();
    }

    protected Set<String> getFieldsToDisplay(Map<String, String> parameters) {
        String val = parameters.get("fields");
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)val)) {
            fields.addAll(Arrays.asList(val.split("\\,")));
        }
        fields.remove("System.Id");
        if (fields.isEmpty()) {
            fields.addAll(WorkItemFieldsController.DEFAULT_PARAMETERS.keySet());
        }
        return fields;
    }

    protected Map<String, String> getAllFields(String baseUrl, String token, String organizationID, String projectName) {
        try {
            GeneralRequest request = new GeneralRequest(organizationID, projectName, null);
            FieldsResponse response = this.azureRestClient.getFields(baseUrl, token, request);
            return response.getValue().stream().collect(Collectors.toMap(FieldsResponse.Field::getReferenceName, FieldsResponse.Field::getName));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return WorkItemFieldsController.DEFAULT_PARAMETERS;
        }
    }

    protected Map<String, Object> workItemToModel(WorkItemResponse workItemResponse) {
        String workItemId = String.valueOf(workItemResponse.getId());
        String url = workItemResponse.getLinks().getHtml().getHref();
        Map<String, Object> workItemFields = workItemResponse.getFields();
        workItemFields.computeIfAbsent("System.AssignedTo", key -> User.unassignedUser());
        IconProperty iconProperty = IconProperty.fromWorkItemType((String)workItemFields.get("System.WorkItemType"));
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("workItemId", workItemId);
        model.put("iconProperty", (Object)iconProperty);
        model.put("stateColour", this.getStateColour((String)workItemFields.get("System.State")));
        model.put("assignee", workItemFields.getOrDefault("System.AssignedTo", User.unassignedUser()));
        model.put("title", workItemFields.get("System.Title"));
        model.put("state", workItemFields.get("System.State"));
        model.put("url", url);
        model.put("workItemFields", workItemFields);
        return model;
    }

    protected String getStateColour(String workItemState) {
        String stateColour = "178, 178, 178";
        if (Arrays.asList("Doing", "Ready", "Active").contains(workItemState)) {
            stateColour = "0, 122, 204";
        }
        return stateColour;
    }

    protected Integer getIntegerValue(Map<String, String> parameters, String name) {
        Integer itemsCount = null;
        try {
            String itemsCountParam = parameters.get(name);
            if (StringUtils.isNotBlank((CharSequence)itemsCountParam)) {
                itemsCount = Integer.parseInt(itemsCountParam);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return itemsCount;
    }
}

