/*
 * Decompiled with CFR 0.152.
 */
package axure.confluence.plugin;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/")
public class AxureResource {
    private final UserManager userManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TransactionTemplate transactionTemplate;

    public AxureResource(UserManager userManager, PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        this.userManager = userManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
    }

    @GET
    @Produces(value={"application/json"})
    public Response get() {
        return Response.ok((Object)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                PluginSettings settings = AxureResource.this.pluginSettingsFactory.createGlobalSettings();
                Config config = new Config();
                String onPremisesIntegration = (String)settings.get(Config.class.getName() + ".onPremisesIntegration");
                if (onPremisesIntegration != null) {
                    config.setOnPremisesIntegration(Boolean.parseBoolean(onPremisesIntegration));
                } else {
                    config.setOnPremisesIntegration(false);
                }
                String onPremisesServerUrls = (String)settings.get(Config.class.getName() + ".onPremisesServerUrls");
                if (onPremisesServerUrls != null && onPremisesServerUrls.length() > 0) {
                    config.setOnPremisesServerUrls(onPremisesServerUrls.split(","));
                } else {
                    config.setOnPremisesServerUrls(new String[0]);
                }
                return config;
            }
        })).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response put(final Config config, @Context HttpServletRequest request) {
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        String userName = userProfile.getUsername();
        UserKey userKey = userProfile.getUserKey();
        if (userName == null || !this.userManager.isSystemAdmin(userKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                PluginSettings pluginSettings = AxureResource.this.pluginSettingsFactory.createGlobalSettings();
                pluginSettings.put(Config.class.getName() + ".onPremisesIntegration", (Object)Boolean.toString(config.getOnPremisesIntegration()));
                pluginSettings.put(Config.class.getName() + ".onPremisesServerUrls", (Object)String.join((CharSequence)",", config.getOnPremisesServerUrls()));
                return null;
            }
        });
        return Response.noContent().build();
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static final class Config {
        @XmlElement
        private boolean onPremisesIntegration;
        @XmlElement
        private String[] onPremisesServerUrls;

        public boolean getOnPremisesIntegration() {
            return this.onPremisesIntegration;
        }

        public void setOnPremisesIntegration(boolean onPremisesIntegration) {
            this.onPremisesIntegration = onPremisesIntegration;
        }

        public String[] getOnPremisesServerUrls() {
            return this.onPremisesServerUrls;
        }

        public void setOnPremisesServerUrls(String[] onPremisesServerUrls) {
            this.onPremisesServerUrls = onPremisesServerUrls;
        }
    }
}

