/*
 * Decompiled with CFR 0.152.
 */
package axure.confluence.plugin;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AxureConfigure
extends HttpServlet {
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;

    public AxureConfigure(UserManager userManager, LoginUriProvider loginUriProvider) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        String userName = userProfile.getUsername();
        UserKey userKey = userProfile.getUserKey();
        if (userName == null || !this.userManager.isSystemAdmin(userKey)) {
            this.redirectToLogin(request, response);
            return;
        }
        Map context = MacroUtils.defaultVelocityContext();
        response.setContentType("text/html;charset=utf-8");
        response.getWriter().write(VelocityUtils.getRenderedTemplate((String)"templates/axure-configure.vm", (Map)context));
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

