define('confluence/autoconvert/axurepaste', ['tinymce'], function(tinymce) {
    'use strict'

    function AxurePaste() {
        var axurePasteHandler = async function (uri, node, done) {
            let axurePasteExtension = window.axure.default.mount(undefined, window.axure.default.AxurePaste);
            if (await axurePasteExtension.isAllowedDomain(uri.source)) {
                let macro = {
                    name: 'axure',
                    params: {
                        Url: uri.source
                    },
                    defaultParameterValue: ''
                };

                tinymce.plugins.Autoconvert.convertMacroToDom(macro, done, done);
            } else {
                done();
            }
        };

        tinymce.plugins.Autoconvert.autoConvert.addHandler(axurePasteHandler);
    };

    return AxurePaste;
});

require('confluence/module-exporter').safeRequire('confluence/autoconvert/axurepaste', function(AxurePaste) {
    require('ajs').bind('init.rte', AxurePaste);
});