(function($) {
    var spaceKey = AJS.$("meta[name='ajs-space-key']").attr("content");
    var spaceAllowed = true;
    let serverUrls = null;
    let macroSettings = {};
    AJS.$.ajax({
        async: false,
        url: `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/config/checkSpace/${spaceKey}`,
        dataType: 'json',
        timeout: 10000,
        error: function(xhr, textStatus, errorThrown) {
            AJS.logError(errorThrown);
            spaceAllowed = true;
        },
        success: function(response) {
            spaceAllowed = response.allowed;
        }
    });
    AJS.$.ajax({
        async: false,
        url: `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/config/effective`,
        dataType: 'json',
        timeout: 10000,
        error: function (xhr, textStatus, errorThrown) {
            AJS.logError(errorThrown);
            serverUrls = null;
            macroSettings = {};
        },
        success: function (response) {
            let setObj = new Set(response.configurations.map(value => value.serverUrl));
            serverUrls = Array.from(setObj);
            macroSettings = response.globalSettings.macroSettings;
        }
    });


    var GitLabConnectorMacro = function() {};
    var originalEpic;
    var originalTag;

    GitLabConnectorMacro.prototype.fields = {
        "date": {
            "fromDate": function (param, options) {
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameter());
                var dateInput = AJS.$("input", paramDiv);
                dateInput.attr("type", "text");
                dateInput.datePicker({
                    overrideBrowserDefault: true,
                    dateFormat: "dd/mm/yy"
                });
                dateInput.on("focus", function () {
                    setTimeout(function () {
                        AJS.$(".aui-datepicker-dialog, .ajs-layer").css("z-index", 5000);
                    }, 0);
                });
                return new AJS.MacroBrowser.Field(paramDiv, dateInput, options);
            },
            "toDate": function (param, options) {
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameter());
                var dateInput = AJS.$("input", paramDiv);
                dateInput.attr("type", "text");
                dateInput.datePicker({
                    overrideBrowserDefault: true,
                    dateFormat: "dd/mm/yy"
                });
                dateInput.on("focus", function () {
                    setTimeout(function () {
                        AJS.$(".aui-datepicker-dialog, .ajs-layer").css("z-index", 5000);
                    }, 0);
                });
                return new AJS.MacroBrowser.Field(paramDiv, dateInput, options);
            },
        },
        "enum": {
            "group": function (param, options) {
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameterSelect());
                var groupSelect = AJS.$("select", paramDiv);
                groupSelect.mwfSelect2({
                    width: "100%",
                    ajax: {
                        url: function (params) {
                            const baseUrl = $("#macro-param-baseUrl").val();
                            return `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/groups?baseUrl=${encodeURIComponent(baseUrl) || ''}`;
                        },
                        type: "GET",
                        processResults: function (data) {
                            const results = data.map(function (item) {
                                return {
                                    id: item.id,
                                    text: item.name,
                                };
                            });
                            return {
                                results: results
                            };
                        }
                    },
                    autocomplete: "on"
                });
                return new AJS.MacroBrowser.Field(paramDiv, groupSelect, options);
            },
            "epic": function(param, options) {
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameterSelect());
                var epicDropdown = AJS.$("select", paramDiv);
                if (!originalEpic) {
                    epicDropdown.prop('disabled', true);
                } else {
                    epicDropdown.prop('disabled', false);
                    setupEpic(epicDropdown);
                }
                $('select#macro-param-group').change(function() {
                    updateEpic(epicDropdown, this.value);
                });
                return new AJS.MacroBrowser.Field(paramDiv, epicDropdown, options);
            },
            "tag": function(param, options) {
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameterSelect());
                var tagDropdown = AJS.$("select", paramDiv);
                if (!originalTag) {
                    tagDropdown.prop('disabled', true);
                } else {
                    tagDropdown.prop('disabled', false);
                    setupTag(tagDropdown);
                }
                $('#macro-param-project').change(function () {
                    updateTag(tagDropdown, this.value);
                });
                return new AJS.MacroBrowser.Field(paramDiv, tagDropdown, options);
            }
        },
        "boolean": {
            "useSnippetId": function (param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["boolean"](param, options);
                var input = AJS.$(parameterField.input);
                input.change(function () {
                    if ($(this).is(":checked")) {
                        $('div#macro-param-div-snippetId').show();
                        $('div#macro-param-div-project').hide();
                        $('div#macro-param-div-snippetTitle').hide();
                    } else {
                        $('div#macro-param-div-snippetId').hide();
                        $('div#macro-param-div-project').show();
                        $('div#macro-param-div-snippetTitle').show();
                    }

                });
                return parameterField;
            },
        },
        "string": {
            "baseUrl": function(param, options) {
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameterSelect());
                var baseUrl = AJS.$("select", paramDiv);
                if(serverUrls) {
                    serverUrls.forEach(serverUrl => {
                        var selectedOption = new Option(serverUrl, serverUrl, false, false);
                        baseUrl.append(selectedOption);
                    });
                }
                return new AJS.MacroBrowser.Field(paramDiv, baseUrl, options);
            },
            "reference": function(param, options) {
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameterSelect());
                var referenceSelect = AJS.$("select", paramDiv);

                referenceSelect.mwfSelect2({
                    width: "100%",
                    ajax: {
                        url: function (params) {
                            const baseUrl = $("#macro-param-baseUrl").val();
                            var projectId = $('#macro-param-project').val();
                            return `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/projects/branches/search?text=${params.term || ''}&projectId=${projectId}&baseUrl=${encodeURIComponent(baseUrl) || ''}`;
                        },
                        type: "GET",
                        processResults: function (data) {
                            let results = data.map(function (item) {
                                return {
                                    id: item,
                                    text: item,
                                };
                            });
                            return {
                                results: results
                            };
                        }
                    },
                    autocomplete: "on"
                });

                return new AJS.MacroBrowser.Field(paramDiv, referenceSelect, options);
            },
            "link": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["_hidden"](param, options);
                var link = AJS.$(parameterField.input);
                return parameterField;
            },
            "milestoneId": function(param, options) {
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameterSelect());
                var milestone = AJS.$("select", paramDiv);
                milestone.mwfSelect2({
                    width: "100%",
                    ajax: {
                        url: function (params) {
                            const baseUrl = $("#macro-param-baseUrl").val();
                            const projectId = $('#macro-param-project').val();
                            return `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/projects/milestones/search?projectId=${projectId}&text=${params.term || ''}&baseUrl=${encodeURIComponent(baseUrl) || ''}`;
                        },
                        type: "GET",
                        processResults: function (data) {
                            const results = data.map(function (item) {
                                return {
                                    id: item.id,
                                    text: item.name
                                };
                            });
                            return {
                                results: results
                            };
                        }
                    },
                    autocomplete: "on"
                });

                return new AJS.MacroBrowser.Field(paramDiv, milestone, options);
            },
            "project": function (param, options) {
                var paramDiv = AJS.$(Confluence.Templates.MacroBrowser.macroParameterSelect());
                var project = AJS.$("select", paramDiv);
                project.mwfSelect2({
                    width: "100%",
                    ajax: {
                        url: function (params) {
                            const baseUrl = $("#macro-param-baseUrl").val();
                            return `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/projects/search?text=${params.term || ''}&baseUrl=${encodeURIComponent(baseUrl) || ''}`;
                        },
                        type: "GET",
                        processResults: function (data) {
                            const results = data.map(function (item) {
                                return {
                                    id: item.id,
                                    text: item.name,
                                    nameWithNamespace: item.nameWithNamespace
                                };
                            });
                            return {
                                results: results
                            };
                        }
                    },
                    autocomplete: "on",
                    templateResult: function (item) {
                        if (item.loading) {
                            return item.text;
                        }
                        var markup = AJS.$("<div>" + item.text + "<br/><span class='select2-results_sub_item'>" + item.nameWithNamespace + "</span></div>");
                        return markup;
                    },
                });
                project.on('select2:select', function (e) {
                    const parent = AJS.$(this).parent();
                    parent.find(".select2-results_sub_item").remove();
                    parent.append("<span class='select2-results_sub_item'>" + e.params.data.nameWithNamespace + "</span>");
                });
                return new AJS.MacroBrowser.Field(paramDiv, project, options);
            },
            "issue": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["_hidden"](param, options);
                return parameterField;
            },
            "issueName": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["string"](param, options);
                var issue = AJS.$(parameterField.input);
                issue.autocompleteMacro({
                    serviceUrl: function() {
                        const baseUrl = $("#macro-param-baseUrl").val();
                        var projectId = $('#macro-param-project').val();
                        return `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/projects/issues/search?projectId=${projectId}&baseUrl=${encodeURIComponent(baseUrl) || ''}`;
                    },
                    preventBadQueries: false,
                    paramName: "text",
                    dataType: "json",
                    minChars: 3,
                    deferRequestBy: 1000,
                    onSelect: function(suggestion) {
                        $('#macro-param-issue').val(suggestion["data"]).change();
                    },
                    onSearchError: function(text, response) {
                        try {
                            var gitLabError = JSON.parse(response.responseText)
                            $('<div style="color: red">' + gitLabError.message + '</div>').insertAfter($("#macro-param-issueName").next())
                                .fadeOut(3500, function() {
                                    $(this).remove();
                                })
                        } catch (error) {
                            $('<div style="color: red">' + response.responseText + '</div>').insertAfter($("#macro-param-issueName").next())
                                .fadeOut(3500, function() {
                                    $(this).remove();
                                })
                        }
                    },
                    transformResult: function(response, originalQuery) {
                        var suggestions = [];
                        if (typeof response !== 'undefined') {
                            var json = {};
                            if (response === 'string') {
                                json = JSON.parse(response.trim())
                            } else {
                                json = response;
                            }
                            suggestions = json.map(function(data) {
                                var entry = {};
                                entry["value"] = data.name;
                                entry["data"] = data.id;
                                return entry;
                            });
                        }
                        var result = {};
                        result["suggestions"] = suggestions;
                        return result;
                    }
                });

                $('#macro-param-project').change(function () {
                    issue.val('');
                    $('input#macro-param-issue').val('');
                });
                return parameterField;
            },
            "snippetId": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["string"](param, options);
                return parameterField;
            },
            "snippetTitle": function(param, options) {
                var parameterField = AJS.MacroBrowser.ParameterFields["string"](param, options);
                var snippet = AJS.$(parameterField.input);
                snippet.autocompleteMacro({
                    serviceUrl: function() {
                        const baseUrl = $("#macro-param-baseUrl").val();
                        var projectId = $('#macro-param-project').val();
                        return `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/projects/snippets/search?projectId=${projectId}&baseUrl=${encodeURIComponent(baseUrl) || ''}`;
                    },
                    preventBadQueries: false,
                    paramName: "text",
                    dataType: "json",
                    minChars: 3,
                    deferRequestBy: 1000,
                    onSelect: function(suggestion) {
                        $('#macro-param-snippetId').val(suggestion["data"]).change();
                    },
                    onSearchError: function(text, response) {
                        try {
                            var gitLabError = JSON.parse(response.responseText)
                            $('<div style="color: red">' + gitLabError.message + '</div>').insertAfter($("#macro-param-snippetTitle").next())
                                .fadeOut(3500, function() {
                                    $(this).remove();
                                })
                        } catch (error) {
                            $('<div style="color: red">' + response.responseText + '</div>').insertAfter($("#macro-param-snippetTitle").next())
                                .fadeOut(3500, function() {
                                    $(this).remove();
                                })
                        }
                    },
                    transformResult: function(response, originalQuery) {
                        var suggestions = [];
                        if (typeof response !== 'undefined') {
                            var json = {};
                            if (response === 'string') {
                                json = JSON.parse(response.trim())
                            } else {
                                json = response;
                            }
                            suggestions = json.map(function(data) {
                                var entry = {};
                                entry["value"] = data.name;
                                entry["data"] = data.id;
                                return entry;
                            });
                        }
                        var result = {};
                        result["suggestions"] = suggestions;
                        return result;
                    }
                });

                $('#macro-param-project').change(function () {
                    snippet.val('');
                    $('input#macro-param-snippetId').val('');
                });
                return parameterField;
            }
        }
    };

    GitLabConnectorMacro.prototype.beforeParamsSet = function (selectedParams, macroSelected) {
        const macroName = AJS.$("input.macro-name").val();
        const settings = macroSettings[macroName];
        if(settings) {
            Object.entries(settings).forEach(([key, value]) => {
                if(!selectedParams.hasOwnProperty(key)) {
                    selectedParams[key] = value;
                }
            });
        }

        if (!spaceAllowed) {
            var macroDesc = $("#macro-insert-container").find(".macro-desc");
            macroDesc.html("Macro is not allowed for this space. Contact administrator to solve the issue.");
            macroDesc.css("border", "1px solid #ff5630");
            macroDesc.css("border-radius", "3px");
            macroDesc.css("padding", "5px");
            macroDesc.parent("form").find(".macro-param-div").remove();
        }
        //backward compatibility
        if (selectedParams.hasOwnProperty('isMarkDown')) {
            var isMarkDown = selectedParams.isMarkDown;
            if (isMarkDown) {
                $('select#macro-param-fileType').val("Mark Down");
            }
        } else if (!selectedParams.hasOwnProperty('fileType') && $('select#macro-param-fileType').length > 0) {
            $('select#macro-param-fileType').val("None");
        }
        const referenceSelect = $('select#macro-param-reference');
        if (referenceSelect.length > 0) {
            referenceSelect.empty();
            referenceSelect.append($("<option>default</option>").attr("value", "default"));
            if (selectedParams.hasOwnProperty('reference')) {
                referenceSelect.append($(`<option>${selectedParams.reference}</option>`).attr("value", selectedParams.reference));
            } else {
                selectedParams.reference = "default";
            }
        }
        if (selectedParams.hasOwnProperty('project')) {
            var projectId = selectedParams.project;
            $('input#macro-param-issue').prop('disabled', false);
            let baseUrl = selectedParams.baseUrl;
            if(!baseUrl) {
                baseUrl = $("#macro-param-baseUrl").val();
            }

            AJS.$.ajax({
                async: false,
                url: `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/projects?projectId=${projectId}&baseUrl=${encodeURIComponent(baseUrl) || ''}`,
                dataType: 'json',
                timeout: 60000,
                error: function (xhr, textStatus, errorThrown) {
                    AJS.logError(errorThrown);
                },
                success: function (response) {
                    var selectedOption = new Option(response.name, projectId, true, true);
                    const projectSelect = AJS.$("#macro-param-project");
                    projectSelect.append(selectedOption);
                    projectSelect.val(projectId).trigger('change');
                    const projectParent = projectSelect.parent();
                    projectParent.find(".select2-results_sub_item").remove();
                    projectParent.append("<span class='select2-results_sub_item'>" + response.nameWithNamespace + "</span>");
                }
            });

        }
        if (selectedParams.hasOwnProperty('issue')) {
            const projectId = selectedParams.project;
            const issueId = selectedParams.issue;
            let baseUrl = selectedParams.baseUrl;
            if(!baseUrl) {
                baseUrl = $("#macro-param-baseUrl").val();
            }
            //loads issue title if it was not set
            if (!selectedParams.hasOwnProperty('issueName')) {
                AJS.$.ajax({
                    async: false,
                    url: `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/projects/issues?projectId=${projectId}&issueId=${issueId}&baseUrl=${encodeURIComponent(baseUrl) || ''}`,
                    dataType: 'json',
                    timeout: 60000,
                    error: function(xhr, textStatus, errorThrown) {
                        AJS.logError(errorThrown);
                    },
                    success: function(response) {
                        selectedParams["issueName"] = response.name;
                    }
                });
            }
        }

        if (selectedParams.hasOwnProperty('milestoneId')) {
            const projectId = selectedParams.project;
            const milestoneId = selectedParams.milestoneId;
            $('input#macro-param-issue').prop('disabled', false);
            let baseUrl = selectedParams.baseUrl;
            if(!baseUrl) {
                baseUrl = $("#macro-param-baseUrl").val();
            }

            AJS.$.ajax({
                async: false,
                url: `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/projects/milestone?projectId=${projectId}&milestoneId=${milestoneId}&baseUrl=${encodeURIComponent(baseUrl) || ''}`,
                dataType: 'json',
                timeout: 60000,
                error: function (xhr, textStatus, errorThrown) {
                    AJS.logError(errorThrown);
                },
                success: function (response) {
                    var selectedOption = new Option(response.name, milestoneId, true, true);
                    const milestoneSelect = AJS.$("#macro-param-milestoneId");
                    milestoneSelect.append(selectedOption);
                    milestoneSelect.val(projectId).trigger('change');
                }
            });

        }
        if (selectedParams.hasOwnProperty('group')) {
            var groupId = selectedParams.group;
            $('input#macro-param-issue').prop('disabled', false);
            let baseUrl = selectedParams.baseUrl;
            if(!baseUrl) {
                baseUrl = $("#macro-param-baseUrl").val();
            }

            AJS.$.ajax({
                async: false,
                url: `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/groups?groupId=${groupId}&baseUrl=${encodeURIComponent(baseUrl) || ''}`,
                dataType: 'json',
                timeout: 60000,
                error: function (xhr, textStatus, errorThrown) {
                    AJS.logError(errorThrown);
                },
                success: function (response) {
                    var selectedOption = new Option(response.name, groupId, true, true);
                    const select = AJS.$("#macro-param-group");
                    select.append(selectedOption);
                    select.val(projectId).trigger('change');
                }
            });
        }
        if (selectedParams.hasOwnProperty('epic')) {
            originalEpic = selectedParams.epic;
        }
        if (selectedParams.hasOwnProperty('tag')) {
            originalTag = selectedParams.tag;
            if (originalTag) {
                updateTag($('select#macro-param-tag'), selectedParams.project);
            }
        }
        if (selectedParams.hasOwnProperty('useSnippetId') && selectedParams.useSnippetId) {
            $('div#macro-param-div-snippetId').show();
            $('div#macro-param-div-project').hide();
            $('div#macro-param-div-snippetTitle').hide();
        } else if ($('div#macro-param-div-snippetId').length > 0) {
            $('div#macro-param-div-snippetId').hide();
            $('div#macro-param-div-project').show();
            $('div#macro-param-div-snippetTitle').show();
        }
        return selectedParams;
    };

    function setupEpic(epicDropdown) {
        if (originalEpic) {
            $('select#macro-param-epic').val(originalEpic).change();
        }
    }

    function setupTag(tagDropdown) {
        if (originalTag) {
            $('select#macro-param-tag').val(originalTag).change();
        }
    }

    function updateTag(tagDropdown, projectId) {
        if (projectId && projectId !== "None") {
            const baseUrl = $("#macro-param-baseUrl").val();
            AJS.$.ajax({
                async: true,
                url: `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/projects/releases?projectId=${projectId}&baseUrl=${encodeURIComponent(baseUrl) || ''}`,
                dataType: 'json',
                timeout: 10000,
                error: function(xhr, textStatus, errorThrown) {
                    AJS.logError(errorThrown);
                    console.log("THERE WAS AN ERROR:" + errorThrown);
                },
                success: function(response) {
                    tagDropdown.empty();
                    tagDropdown.append($("<option>The latest</option>").attr("value", "latest"));
                    tagDropdown.prop('disabled', false);
                    for (var i = 0; i < response.length; i++) {
                        tagDropdown.append($("<option></option>").val(response[i].key).html(response[i].value));
                    }
                    setupTag(tagDropdown);
                }
            });
        } else {
            tagDropdown.empty();
            tagDropdown.append($("<option>None</option>").attr("value", ""));
        }
    }

    function updateEpic(epicDropdown, groupId) {
        if (groupId !== "None") {
            const baseUrl = $("#macro-param-baseUrl").val();
            AJS.$.ajax({
                async: true,
                url: `${AJS.contextPath()}/rest/rumpelcoders/gitlab-api/1.0/groups/${groupId}/epics?baseUrl=${encodeURIComponent(baseUrl) || ''}`,
                dataType: 'json',
                timeout: 10000,
                error: function(xhr, textStatus, errorThrown) {
                    AJS.logError(errorThrown);
                    console.log("THERE WAS AN ERROR:" + errorThrown);
                },
                success: function(response) {
                    epicDropdown.empty();
                    epicDropdown.append($("<option>None</option>").attr("value", ""));
                    epicDropdown.prop('disabled', false);
                    for (var i = 0; i < response.length; i++) {
                        epicDropdown.append($("<option></option>").val(response[i].id).html(response[i].name));
                    }
                    setupEpic(epicDropdown);
                }
            });
        } else {
            epicDropdown.empty();
            epicDropdown.append($("<option>None</option>").attr("value", ""));
        }
    }

    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-issue", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-issues", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-projects", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-project", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-builds", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-mergerequests", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-epic", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-file", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-snippet", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-groups", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-commit", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-release", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-list-milestones", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-milestone", new GitLabConnectorMacro());
    AJS.MacroBrowser.setMacroJsOverride("gitlab-api-issues-gantt-chart", new GitLabConnectorMacro());

})(AJS.$);