/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandArchimateMultilines
extends CommandMultilines2<AbstractEntityDiagram> {
    public CommandArchimateMultilines() {
        super(CommandArchimateMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    @Override
    public String getPatternEnd() {
        return "^(.*)\\]$";
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandArchimateMultilines.class.getName(), RegexLeaf.start(), new RegexLeaf("archimate"), RegexLeaf.spaceOneOrMore(), CommandArchimateMultilines.color().getRegex(), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([%pLN_.]+)"), StereotypePattern.optionalArchimate("STEREOTYPE"), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\["), new RegexLeaf("DESC", "(.*)"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeNow(AbstractEntityDiagram diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trim();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String codeRaw = line0.getLazzy("CODE", 0);
        Quark<Entity> quark = diagram.quarkInContext(false, diagram.cleanId(codeRaw));
        if (quark.getData() != null) {
            return CommandExecutionResult.error("Already exists " + quark.getName());
        }
        String icon = StereotypePattern.removeChevronBrackets(line0.getLazzy("STEREOTYPE", 0));
        Entity entity = diagram.reallyCreateLeaf(quark, Display.getWithNewlines(quark), LeafType.DESCRIPTION, USymbols.RECTANGLE);
        lines = lines.subExtract(1, 1);
        Display display = lines.toDisplay();
        entity.setDisplay(display);
        if (icon != null) {
            entity.setStereotype(Stereotype.build("<<$archimate/" + icon + ">>", diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        Colors colors = CommandArchimateMultilines.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        entity.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

