/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Html5Entities;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Escaping {
    public static final String ESCAPABLE_CHARS = "\"#$%&'()*+,./:;<=>?@[]\\^_`{|}~-";
    public static final String ESCAPABLE = "[!" + "\"#$%&'()*+,./:;<=>?@[]\\^_`{|}~-".replace("\\", "\\\\").replace("[", "\\[").replace("]", "\\]") + "]";
    private static final String ENTITY = "&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});";
    private static final Pattern BACKSLASH_ONLY = Pattern.compile("[\\\\]");
    private static final Pattern ESCAPED_CHAR = Pattern.compile("\\\\" + ESCAPABLE, 2);
    private static final Pattern BACKSLASH_OR_AMP = Pattern.compile("[\\\\&]");
    private static final Pattern AMP_ONLY = Pattern.compile("[\\&]");
    private static final Pattern ENTITY_OR_ESCAPED_CHAR = Pattern.compile("\\\\" + ESCAPABLE + "|&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});", 2);
    private static final Pattern ENTITY_ONLY = Pattern.compile("&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});", 2);
    private static final String XML_SPECIAL = "[&<>\"]";
    private static final Pattern XML_SPECIAL_RE = Pattern.compile("[&<>\"]");
    private static final Pattern XML_SPECIAL_OR_ENTITY = Pattern.compile("&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});|[&<>\"]", 2);
    private static final Pattern ESCAPE_IN_URI = Pattern.compile("(%[a-fA-F0-9]{0,2}|[^:/?#@!$&'()*+,;=a-zA-Z0-9\\-._~])");
    private static final Pattern ESCAPE_URI_DECODE = Pattern.compile("(%[a-fA-F0-9]{2})");
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern WHITESPACE = Pattern.compile("[ \t\r\n]+");
    private static final Pattern COLLAPSE_WHITESPACE = Pattern.compile("[ \t]{2,}");
    private static final Replacer UNSAFE_CHAR_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s2, @NotNull StringBuilder sb) {
            switch (s2) {
                case "&": {
                    sb.append("&amp;");
                    break;
                }
                case "<": {
                    sb.append("&lt;");
                    break;
                }
                case ">": {
                    sb.append("&gt;");
                    break;
                }
                case "\"": {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(s2);
                }
            }
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            String s1;
            switch (s1 = original.subSequence(startIndex, endIndex).toString()) {
                case "&": {
                    textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf("&amp;", BasedSequence.NULL));
                    break;
                }
                case "<": {
                    textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf("&lt;", BasedSequence.NULL));
                    break;
                }
                case ">": {
                    textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf("&gt;", BasedSequence.NULL));
                    break;
                }
                case "\"": {
                    textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf("&quot;", BasedSequence.NULL));
                    break;
                }
                default: {
                    textMapper.addOriginalText(startIndex, endIndex);
                }
            }
        }
    };
    private static final Replacer COLLAPSE_WHITESPACE_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s2, @NotNull StringBuilder sb) {
            sb.append(" ");
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            textMapper.addReplacedText(startIndex, endIndex, original.subSequence(startIndex, startIndex + 1));
        }
    };
    private static final Replacer UNESCAPE_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s2, @NotNull StringBuilder sb) {
            if (s2.charAt(0) == '\\') {
                sb.append(s2, 1, s2.length());
            } else {
                sb.append(Html5Entities.entityToString(s2));
            }
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            if (original.charAt(startIndex) == '\\') {
                textMapper.addReplacedText(startIndex, endIndex, original.subSequence(startIndex + 1, endIndex));
            } else {
                textMapper.addReplacedText(startIndex, endIndex, Html5Entities.entityToSequence(original.subSequence(startIndex, endIndex)));
            }
        }
    };
    private static final Replacer REMOVE_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s2, @NotNull StringBuilder sb) {
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            textMapper.addReplacedText(startIndex, endIndex, original.subSequence(endIndex, endIndex));
        }
    };
    private static final Replacer ENTITY_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s2, @NotNull StringBuilder sb) {
            sb.append(Html5Entities.entityToString(s2));
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            textMapper.addReplacedText(startIndex, endIndex, Html5Entities.entityToSequence(original.subSequence(startIndex, endIndex)));
        }
    };
    private static final Replacer URL_ENCODE_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s2, @NotNull StringBuilder sb) {
            if (s2.startsWith("%")) {
                if (s2.length() == 3) {
                    sb.append(s2);
                } else {
                    sb.append("%25");
                    sb.append(s2, 1, s2.length());
                }
            } else {
                byte[] bytes;
                for (byte b : bytes = s2.getBytes(StandardCharsets.UTF_8)) {
                    sb.append('%');
                    sb.append(HEX_DIGITS[b >> 4 & 0xF]);
                    sb.append(HEX_DIGITS[b & 0xF]);
                }
            }
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            BasedSequence s2 = original.subSequence(startIndex, endIndex);
            if (s2.startsWith("%")) {
                if (s2.length() == 3) {
                    textMapper.addOriginalText(startIndex, endIndex);
                } else {
                    textMapper.addReplacedText(startIndex, startIndex + 1, PrefixedSubSequence.prefixOf("%25", BasedSequence.NULL));
                    textMapper.addOriginalText(startIndex + 1, endIndex);
                }
            } else {
                byte[] bytes = s2.toString().getBytes(StandardCharsets.UTF_8);
                StringBuilder sbItem = new StringBuilder();
                for (byte b : bytes) {
                    sbItem.append('%');
                    sbItem.append(HEX_DIGITS[b >> 4 & 0xF]);
                    sbItem.append(HEX_DIGITS[b & 0xF]);
                }
                textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf(sbItem.toString(), BasedSequence.NULL));
            }
        }
    };
    private static final Replacer URL_DECODE_REPLACER = new Replacer(){

        @Override
        public void replace(@NotNull String s2, @NotNull StringBuilder sb) {
            String urlDecoded = Utils.urlDecode(s2, null);
            sb.append(urlDecoded);
        }

        @Override
        public void replace(@NotNull BasedSequence original, int startIndex, int endIndex, @NotNull ReplacedTextMapper textMapper) {
            BasedSequence s2 = original.subSequence(startIndex, endIndex);
            String decoded = Utils.urlDecode(s2.toString(), null);
            textMapper.addReplacedText(startIndex, endIndex, PrefixedSubSequence.prefixOf(decoded, BasedSequence.NULL));
        }
    };
    @NotNull
    public static final CharPredicate AMP_BACKSLASH_SET = CharPredicate.anyOf('\\', '&');
    private static Random random = new Random(9766L);

    public static String escapeHtml(@NotNull CharSequence s2, boolean preserveEntities) {
        Pattern p = preserveEntities ? XML_SPECIAL_OR_ENTITY : XML_SPECIAL_RE;
        return Escaping.replaceAll(p, s2, UNSAFE_CHAR_REPLACER);
    }

    @NotNull
    public static BasedSequence escapeHtml(@NotNull BasedSequence s2, boolean preserveEntities, @NotNull ReplacedTextMapper textMapper) {
        Pattern p = preserveEntities ? XML_SPECIAL_OR_ENTITY : XML_SPECIAL_RE;
        return Escaping.replaceAll(p, s2, UNSAFE_CHAR_REPLACER, textMapper);
    }

    @NotNull
    public static String unescapeString(@NotNull CharSequence s2) {
        if (BACKSLASH_OR_AMP.matcher(s2).find()) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s2, UNESCAPE_REPLACER);
        }
        return String.valueOf(s2);
    }

    @NotNull
    public static String unescapeString(@NotNull CharSequence s2, boolean unescapeEntities) {
        if (unescapeEntities) {
            if (BACKSLASH_OR_AMP.matcher(s2).find()) {
                return Escaping.replaceAll(ESCAPED_CHAR, s2, UNESCAPE_REPLACER);
            }
            return String.valueOf(s2);
        }
        if (BACKSLASH_ONLY.matcher(s2).find()) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s2, UNESCAPE_REPLACER);
        }
        return String.valueOf(s2);
    }

    @NotNull
    public static BasedSequence unescape(@NotNull BasedSequence s2, @NotNull ReplacedTextMapper textMapper) {
        int indexOfAny = s2.indexOfAny(AMP_BACKSLASH_SET);
        if (indexOfAny != -1) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s2, UNESCAPE_REPLACER, textMapper);
        }
        return s2;
    }

    @NotNull
    public static BasedSequence removeAll(@NotNull BasedSequence s2, @NotNull CharSequence remove, @NotNull ReplacedTextMapper textMapper) {
        int indexOf = s2.indexOf(remove);
        if (indexOf != -1) {
            return Escaping.replaceAll(Pattern.compile("\\Q" + remove + "\\E"), s2, REMOVE_REPLACER, textMapper);
        }
        return s2;
    }

    @NotNull
    public static String unescapeHtml(@NotNull CharSequence s2) {
        if (AMP_ONLY.matcher(s2).find()) {
            return Escaping.replaceAll(ENTITY_ONLY, s2, ENTITY_REPLACER);
        }
        return String.valueOf(s2);
    }

    @NotNull
    public static BasedSequence unescapeHtml(@NotNull BasedSequence s2, @NotNull ReplacedTextMapper textMapper) {
        int indexOfAny = s2.indexOf('&');
        if (indexOfAny != -1) {
            return Escaping.replaceAll(ENTITY_ONLY, s2, ENTITY_REPLACER, textMapper);
        }
        return s2;
    }

    @NotNull
    public static BasedSequence unescapeHtml(@NotNull BasedSequence s2, @NotNull List<Range> ranges, @NotNull ReplacedTextMapper textMapper) {
        int indexOfAny = s2.indexOf('&');
        if (indexOfAny != -1) {
            return Escaping.replaceAll(ENTITY_ONLY, s2, ranges, ENTITY_REPLACER, textMapper);
        }
        return s2;
    }

    @NotNull
    public static String normalizeEndWithEOL(@NotNull CharSequence s2) {
        return Escaping.normalizeEOL(s2, true);
    }

    @NotNull
    public static String normalizeEOL(@NotNull CharSequence s2) {
        return Escaping.normalizeEOL(s2, false);
    }

    @NotNull
    public static String normalizeEOL(@NotNull CharSequence s2, boolean endWithEOL) {
        StringBuilder sb = new StringBuilder(s2.length());
        int iMax = s2.length();
        boolean hadCR = false;
        boolean hadEOL = false;
        for (int i = 0; i < iMax; ++i) {
            char c = s2.charAt(i);
            if (c == '\r') {
                hadCR = true;
                continue;
            }
            if (c == '\n') {
                sb.append("\n");
                hadCR = false;
                hadEOL = true;
                continue;
            }
            if (hadCR) {
                sb.append('\n');
            }
            sb.append(c);
            hadCR = false;
            hadEOL = false;
        }
        if (endWithEOL && !hadEOL) {
            sb.append('\n');
        }
        return sb.toString();
    }

    @NotNull
    public static BasedSequence normalizeEndWithEOL(@NotNull BasedSequence s2, @NotNull ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(s2, textMapper, true);
    }

    @NotNull
    public static BasedSequence normalizeEOL(@NotNull BasedSequence s2, @NotNull ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(s2, textMapper, false);
    }

    @NotNull
    public static BasedSequence normalizeEOL(@NotNull BasedSequence s2, @NotNull ReplacedTextMapper textMapper, boolean endWithEOL) {
        int iMax = s2.length();
        int lastPos = 0;
        boolean hadCR = false;
        boolean hadEOL = false;
        if (textMapper.isModified()) {
            textMapper.startNestedReplacement(s2);
        }
        for (int i = 0; i < iMax; ++i) {
            char c = s2.charAt(i);
            if (c == '\r') {
                hadCR = true;
                continue;
            }
            if (c == '\n') {
                if (!hadCR) continue;
                if (lastPos < i - 1) {
                    textMapper.addOriginalText(lastPos, i - 1);
                }
                lastPos = i;
                hadCR = false;
                hadEOL = true;
                continue;
            }
            if (!hadCR) continue;
            if (lastPos < i - 1) {
                textMapper.addOriginalText(lastPos, i + 1);
            }
            textMapper.addReplacedText(i - 1, i, BasedSequence.EOL);
            lastPos = i;
            hadCR = false;
            hadEOL = false;
        }
        if (!hadCR) {
            if (lastPos < iMax) {
                textMapper.addOriginalText(lastPos, iMax);
            }
            if (!hadEOL && endWithEOL) {
                textMapper.addReplacedText(iMax - 1, iMax, BasedSequence.EOL);
            }
        }
        return textMapper.getReplacedSequence();
    }

    @NotNull
    public static String percentEncodeUrl(@NotNull CharSequence s2) {
        return Escaping.replaceAll(ESCAPE_IN_URI, s2, URL_ENCODE_REPLACER);
    }

    @NotNull
    public static BasedSequence percentEncodeUrl(@NotNull BasedSequence s2, @NotNull ReplacedTextMapper textMapper) {
        return Escaping.replaceAll(ESCAPE_IN_URI, s2, URL_ENCODE_REPLACER, textMapper);
    }

    @NotNull
    public static String percentDecodeUrl(@NotNull CharSequence s2) {
        return Escaping.replaceAll(ESCAPE_URI_DECODE, s2, URL_DECODE_REPLACER);
    }

    @NotNull
    public static BasedSequence percentDecodeUrl(@NotNull BasedSequence s2, @NotNull ReplacedTextMapper textMapper) {
        return Escaping.replaceAll(ESCAPE_URI_DECODE, s2, URL_DECODE_REPLACER, textMapper);
    }

    @NotNull
    public static String normalizeReference(@NotNull CharSequence s2, boolean changeCase) {
        if (changeCase) {
            return Escaping.collapseWhitespace(s2.toString(), true).toLowerCase();
        }
        return Escaping.collapseWhitespace(s2.toString(), true);
    }

    @Nullable
    private static String encode(char c) {
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&#39;";
            }
        }
        return null;
    }

    @NotNull
    public static String obfuscate(@NotNull String email, boolean randomize) {
        if (!randomize) {
            random = new Random(0L);
        }
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < email.length(); ++i) {
            char c = email.charAt(i);
            switch (random.nextInt(5)) {
                case 0: 
                case 1: {
                    sb.append("&#").append((int)c).append(';');
                    continue block5;
                }
                case 2: 
                case 3: {
                    sb.append("&#x").append(Integer.toHexString(c)).append(';');
                    continue block5;
                }
                case 4: {
                    String encoded = Escaping.encode(c);
                    if (encoded != null) {
                        sb.append(encoded);
                        continue block5;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @NotNull
    public static String normalizeReferenceChars(@NotNull CharSequence s2, boolean changeCase) {
        if (s2.length() > 1) {
            int stripEnd = s2.charAt(s2.length() - 1) == ':' ? 2 : 1;
            int stripStart = s2.charAt(0) == '!' ? 2 : 1;
            return Escaping.normalizeReference(s2.subSequence(stripStart, s2.length() - stripEnd), changeCase);
        }
        return String.valueOf(s2);
    }

    @NotNull
    public static String collapseWhitespace(@NotNull CharSequence s2, boolean trim) {
        StringBuilder sb = new StringBuilder(s2.length());
        int iMax = s2.length();
        boolean hadSpace = false;
        for (int i = 0; i < iMax; ++i) {
            char c = s2.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                hadSpace = true;
                continue;
            }
            if (hadSpace && (!trim || sb.length() > 0)) {
                sb.append(' ');
            }
            sb.append(c);
            hadSpace = false;
        }
        if (hadSpace && !trim) {
            sb.append(' ');
        }
        return sb.toString();
    }

    @NotNull
    public static BasedSequence collapseWhitespace(@NotNull BasedSequence s2, @NotNull ReplacedTextMapper textMapper) {
        return Escaping.replaceAll(COLLAPSE_WHITESPACE, s2, COLLAPSE_WHITESPACE_REPLACER, textMapper);
    }

    @NotNull
    private static String replaceAll(@NotNull Pattern p, @NotNull CharSequence s2, @NotNull Replacer replacer) {
        Matcher matcher = p.matcher(s2);
        if (!matcher.find()) {
            return String.valueOf(s2);
        }
        StringBuilder sb = new StringBuilder(s2.length() + 16);
        int lastEnd = 0;
        do {
            sb.append(s2, lastEnd, matcher.start());
            replacer.replace(matcher.group(), sb);
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd != s2.length()) {
            sb.append(s2, lastEnd, s2.length());
        }
        return sb.toString();
    }

    @NotNull
    private static BasedSequence replaceAll(@NotNull Pattern p, @NotNull BasedSequence s2, @NotNull Replacer replacer, @NotNull ReplacedTextMapper textMapper) {
        return Escaping.replaceAll(p, s2, 0, s2.length(), replacer, textMapper);
    }

    @NotNull
    private static BasedSequence replaceAll(@NotNull Pattern p, @NotNull BasedSequence s2, int startOffset, int endOffset, @NotNull Replacer replacer, @NotNull ReplacedTextMapper textMapper) {
        Matcher matcher = p.matcher(s2);
        matcher.region(startOffset, endOffset);
        matcher.useTransparentBounds(false);
        if (textMapper.isModified()) {
            textMapper.startNestedReplacement(s2);
        }
        if (!matcher.find()) {
            textMapper.addOriginalText(0, s2.length());
            return s2;
        }
        int lastEnd = 0;
        do {
            textMapper.addOriginalText(lastEnd, matcher.start());
            replacer.replace(s2, matcher.start(), matcher.end(), textMapper);
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd < s2.length()) {
            textMapper.addOriginalText(lastEnd, s2.length());
        }
        return textMapper.getReplacedSequence();
    }

    @NotNull
    private static BasedSequence replaceAll(@NotNull Pattern p, @NotNull BasedSequence s2, @NotNull List<Range> ranges, @NotNull Replacer replacer, @NotNull ReplacedTextMapper textMapper) {
        Matcher matcher = p.matcher(s2);
        matcher.useTransparentBounds(false);
        if (textMapper.isModified()) {
            textMapper.startNestedReplacement(s2);
        }
        int lastEnd = 0;
        for (Range range : ranges) {
            int start = Utils.rangeLimit(range.getStart(), lastEnd, s2.length());
            int end = Utils.rangeLimit(range.getEnd(), start, s2.length());
            matcher.region(start, end);
            while (matcher.find()) {
                textMapper.addOriginalText(lastEnd, matcher.start());
                replacer.replace(s2, matcher.start(), matcher.end(), textMapper);
                lastEnd = matcher.end();
            }
        }
        if (lastEnd < s2.length()) {
            textMapper.addOriginalText(lastEnd, s2.length());
        }
        return textMapper.getReplacedSequence();
    }

    static interface Replacer {
        public void replace(@NotNull String var1, @NotNull StringBuilder var2);

        public void replace(@NotNull BasedSequence var1, int var2, int var3, @NotNull ReplacedTextMapper var4);
    }
}

