/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html.ui;

import com.vladsch.flexmark.util.html.ui.BackgroundColor;
import com.vladsch.flexmark.util.html.ui.HtmlStylerBase;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;

public class ColorStyler
extends HtmlStylerBase<Color> {
    public static final HashMap<Integer, String> colorNameMap = new HashMap();
    public static final HashMap<String, Integer> nameColorMap = new HashMap();

    @Override
    public String getStyle(Color item) {
        if (item instanceof BackgroundColor) {
            return String.format("background-color:#%s", ColorStyler.getColorValue(item));
        }
        return item == null ? "" : String.format("color:#%s", ColorStyler.getColorValue(item));
    }

    public static Color getNamedColor(String colorName) {
        if (colorName.startsWith("#")) {
            Integer color = SequenceUtils.parseIntOrNull(colorName.substring(1), 16);
            if (color == null) {
                return null;
            }
            String colorText = colorName.substring(1);
            Object r = "";
            Object g2 = "";
            Object b = "";
            Object a = "";
            switch (colorText.length()) {
                case 3: {
                    r = colorText.substring(0, 1);
                    g2 = colorText.substring(1, 2);
                    b = colorText.substring(2, 3);
                    break;
                }
                case 4: {
                    r = colorText.substring(0, 1);
                    g2 = colorText.substring(1, 2);
                    b = colorText.substring(2, 3);
                    a = colorText.substring(3, 4);
                    break;
                }
                case 6: {
                    r = colorText.substring(0, 2);
                    g2 = colorText.substring(2, 4);
                    b = colorText.substring(4, 6);
                    break;
                }
                case 8: {
                    r = colorText.substring(0, 2);
                    g2 = colorText.substring(2, 4);
                    b = colorText.substring(4, 6);
                    b = colorText.substring(6, 8);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (((String)r).length() == 1) {
                r = (String)r + (String)r;
            }
            if (((String)g2).length() == 1) {
                g2 = (String)g2 + (String)g2;
            }
            if (((String)b).length() == 1) {
                b = (String)b + (String)b;
            }
            if (((String)a).length() == 1) {
                a = (String)a + (String)a;
            }
            if (((String)a).isEmpty()) {
                a = "ff";
            }
            return new Color(ColorStyler.parse((String)r), ColorStyler.parse((String)g2), ColorStyler.parse((String)b), ColorStyler.parse((String)a));
        }
        Integer rgb = nameColorMap.get(colorName);
        return rgb == null ? null : new Color(rgb);
    }

    static int parse(String color) {
        return Integer.parseInt(color, 16);
    }

    public static String getColorName(Color item) {
        return item != null ? colorNameMap.get(item.getRGB() & 0xFFFFFF) : null;
    }

    public static String getColorValue(Color item) {
        return item == null ? "" : (item.getAlpha() != 255 ? String.format(Locale.US, "rgba(%d,%d,%d,%d)", item.getRed(), item.getGreen(), item.getBlue(), item.getAlpha()) : String.format(Locale.US, "%02x%02x%02x", item.getRed(), item.getGreen(), item.getBlue()));
    }

    public static String getColorNameOrRGB(Color item) {
        if (item != null) {
            int rgb = item.getRGB();
            String colorName = colorNameMap.get(rgb & 0xFFFFFF);
            return colorName != null ? colorName : String.format(Locale.US, "rgb(%d,%d,%d)", item.getRed(), item.getGreen(), item.getBlue());
        }
        return "";
    }

    private static void addColorName(int rgb, String name) {
        colorNameMap.put(rgb, name);
        nameColorMap.put(name, rgb);
    }

    static {
        ColorStyler.addColorName(0, "black");
        ColorStyler.addColorName(128, "navy");
        ColorStyler.addColorName(139, "darkblue");
        ColorStyler.addColorName(205, "mediumblue");
        ColorStyler.addColorName(255, "blue");
        ColorStyler.addColorName(25600, "darkgreen");
        ColorStyler.addColorName(32768, "green");
        ColorStyler.addColorName(32896, "teal");
        ColorStyler.addColorName(35723, "darkcyan");
        ColorStyler.addColorName(49151, "deepskyblue");
        ColorStyler.addColorName(52945, "darkturquoise");
        ColorStyler.addColorName(64154, "mediumspringgreen");
        ColorStyler.addColorName(65280, "lime");
        ColorStyler.addColorName(65407, "springgreen");
        ColorStyler.addColorName(65535, "aqua");
        ColorStyler.addColorName(1644912, "midnightblue");
        ColorStyler.addColorName(2003199, "dodgerblue");
        ColorStyler.addColorName(2142890, "lightseagreen");
        ColorStyler.addColorName(0x228B22, "forestgreen");
        ColorStyler.addColorName(3050327, "seagreen");
        ColorStyler.addColorName(0x2F4F4F, "darkslategray");
        ColorStyler.addColorName(0x2F4F4F, "darkslategrey");
        ColorStyler.addColorName(3329330, "limegreen");
        ColorStyler.addColorName(3978097, "mediumseagreen");
        ColorStyler.addColorName(4251856, "turquoise");
        ColorStyler.addColorName(4286945, "royalblue");
        ColorStyler.addColorName(4620980, "steelblue");
        ColorStyler.addColorName(4734347, "darkslateblue");
        ColorStyler.addColorName(4772300, "mediumturquoise");
        ColorStyler.addColorName(4915330, "indigo");
        ColorStyler.addColorName(5597999, "darkolivegreen");
        ColorStyler.addColorName(6266528, "cadetblue");
        ColorStyler.addColorName(6591981, "cornflowerblue");
        ColorStyler.addColorName(0x663399, "rebeccapurple");
        ColorStyler.addColorName(6737322, "mediumaquamarine");
        ColorStyler.addColorName(0x696969, "dimgray");
        ColorStyler.addColorName(0x696969, "dimgrey");
        ColorStyler.addColorName(6970061, "slateblue");
        ColorStyler.addColorName(7048739, "olivedrab");
        ColorStyler.addColorName(7372944, "slategray");
        ColorStyler.addColorName(7372944, "slategrey");
        ColorStyler.addColorName(0x778899, "lightslategray");
        ColorStyler.addColorName(0x778899, "lightslategrey");
        ColorStyler.addColorName(8087790, "mediumslateblue");
        ColorStyler.addColorName(8190976, "lawngreen");
        ColorStyler.addColorName(0x7FFF00, "chartreuse");
        ColorStyler.addColorName(8388564, "aquamarine");
        ColorStyler.addColorName(0x800000, "maroon");
        ColorStyler.addColorName(0x800080, "purple");
        ColorStyler.addColorName(0x808000, "olive");
        ColorStyler.addColorName(0x808080, "gray");
        ColorStyler.addColorName(0x808080, "grey");
        ColorStyler.addColorName(8900331, "skyblue");
        ColorStyler.addColorName(8900346, "lightskyblue");
        ColorStyler.addColorName(9055202, "blueviolet");
        ColorStyler.addColorName(0x8B0000, "darkred");
        ColorStyler.addColorName(0x8B008B, "darkmagenta");
        ColorStyler.addColorName(9127187, "saddlebrown");
        ColorStyler.addColorName(9419919, "darkseagreen");
        ColorStyler.addColorName(0x90EE90, "lightgreen");
        ColorStyler.addColorName(9662683, "mediumpurple");
        ColorStyler.addColorName(9699539, "darkviolet");
        ColorStyler.addColorName(10025880, "palegreen");
        ColorStyler.addColorName(10040012, "darkorchid");
        ColorStyler.addColorName(10145074, "yellowgreen");
        ColorStyler.addColorName(10506797, "sienna");
        ColorStyler.addColorName(0xA52A2A, "brown");
        ColorStyler.addColorName(0xA9A9A9, "darkgray");
        ColorStyler.addColorName(0xA9A9A9, "darkgrey");
        ColorStyler.addColorName(11393254, "lightblue");
        ColorStyler.addColorName(11403055, "greenyellow");
        ColorStyler.addColorName(0xAFEEEE, "paleturquoise");
        ColorStyler.addColorName(11584734, "lightsteelblue");
        ColorStyler.addColorName(11591910, "powderblue");
        ColorStyler.addColorName(0xB22222, "firebrick");
        ColorStyler.addColorName(12092939, "darkgoldenrod");
        ColorStyler.addColorName(12211667, "mediumorchid");
        ColorStyler.addColorName(12357519, "rosybrown");
        ColorStyler.addColorName(12433259, "darkkhaki");
        ColorStyler.addColorName(0xC0C0C0, "silver");
        ColorStyler.addColorName(13047173, "mediumvioletred");
        ColorStyler.addColorName(0xCD5C5C, "indianred");
        ColorStyler.addColorName(13468991, "peru");
        ColorStyler.addColorName(13789470, "chocolate");
        ColorStyler.addColorName(13808780, "tan");
        ColorStyler.addColorName(0xD3D3D3, "lightgray");
        ColorStyler.addColorName(0xD3D3D3, "lightgrey");
        ColorStyler.addColorName(14204888, "thistle");
        ColorStyler.addColorName(14315734, "orchid");
        ColorStyler.addColorName(14329120, "goldenrod");
        ColorStyler.addColorName(14381203, "palevioletred");
        ColorStyler.addColorName(14423100, "crimson");
        ColorStyler.addColorName(0xDCDCDC, "gainsboro");
        ColorStyler.addColorName(0xDDA0DD, "plum");
        ColorStyler.addColorName(14596231, "burlywood");
        ColorStyler.addColorName(0xE0FFFF, "lightcyan");
        ColorStyler.addColorName(15132410, "lavender");
        ColorStyler.addColorName(15308410, "darksalmon");
        ColorStyler.addColorName(0xEE82EE, "violet");
        ColorStyler.addColorName(0xEEE8AA, "palegoldenrod");
        ColorStyler.addColorName(0xF08080, "lightcoral");
        ColorStyler.addColorName(15787660, "khaki");
        ColorStyler.addColorName(0xF0F8FF, "aliceblue");
        ColorStyler.addColorName(0xF0FFF0, "honeydew");
        ColorStyler.addColorName(0xF0FFFF, "azure");
        ColorStyler.addColorName(16032864, "sandybrown");
        ColorStyler.addColorName(16113331, "wheat");
        ColorStyler.addColorName(16119260, "beige");
        ColorStyler.addColorName(0xF5F5F5, "whitesmoke");
        ColorStyler.addColorName(0xF5FFFA, "mintcream");
        ColorStyler.addColorName(0xF8F8FF, "ghostwhite");
        ColorStyler.addColorName(16416882, "salmon");
        ColorStyler.addColorName(16444375, "antiquewhite");
        ColorStyler.addColorName(16445670, "linen");
        ColorStyler.addColorName(16448210, "lightgoldenrodyellow");
        ColorStyler.addColorName(16643558, "oldlace");
        ColorStyler.addColorName(0xFF0000, "red");
        ColorStyler.addColorName(0xFF00FF, "fuchsia");
        ColorStyler.addColorName(16716947, "deeppink");
        ColorStyler.addColorName(16729344, "orangered");
        ColorStyler.addColorName(16737095, "tomato");
        ColorStyler.addColorName(16738740, "hotpink");
        ColorStyler.addColorName(16744272, "coral");
        ColorStyler.addColorName(16747520, "darkorange");
        ColorStyler.addColorName(16752762, "lightsalmon");
        ColorStyler.addColorName(16753920, "orange");
        ColorStyler.addColorName(16758465, "lightpink");
        ColorStyler.addColorName(16761035, "pink");
        ColorStyler.addColorName(16766720, "gold");
        ColorStyler.addColorName(16767673, "peachpuff");
        ColorStyler.addColorName(16768685, "navajowhite");
        ColorStyler.addColorName(16770229, "moccasin");
        ColorStyler.addColorName(16770244, "bisque");
        ColorStyler.addColorName(16770273, "mistyrose");
        ColorStyler.addColorName(16772045, "blanchedalmond");
        ColorStyler.addColorName(16773077, "papayawhip");
        ColorStyler.addColorName(0xFFF0F5, "lavenderblush");
        ColorStyler.addColorName(0xFFF5EE, "seashell");
        ColorStyler.addColorName(16775388, "cornsilk");
        ColorStyler.addColorName(16775885, "lemonchiffon");
        ColorStyler.addColorName(0xFFFAF0, "floralwhite");
        ColorStyler.addColorName(0xFFFAFA, "snow");
        ColorStyler.addColorName(0xFFFF00, "yellow");
        ColorStyler.addColorName(0xFFFFE0, "lightyellow");
        ColorStyler.addColorName(0xFFFFF0, "ivory");
        ColorStyler.addColorName(0xFFFFFF, "white");
    }
}

