/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class MwfPropertyUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MwfPropertyUtils.class);
    public static final List<String> DEV_PROPERTIES = Collections.unmodifiableList(Arrays.asList("moveworkforward.dev.mode", "mwfDevMode"));
    public static final List<String> DEV_UI_PROPERTIES = Collections.unmodifiableList(Arrays.asList("moveworkforward.dev.local.ui", "mwfDevLocalUi"));
    public static String STATISTICS_URL = "statisticsUrl";
    public static String STATISTICS_SECRET = "statisticsSecret";
    public static String STATISTICS_CRON_EXPRESSION = "statisticsCronExpression";
    private final Properties properties = new Properties();
    private volatile boolean initialized;
    private static final MwfPropertyUtils INSTANCE = new MwfPropertyUtils(new String[0]);

    public static MwfPropertyUtils getInstance() {
        return INSTANCE;
    }

    public MwfPropertyUtils(String ... fileNames) {
        this.initialize(fileNames);
    }

    protected synchronized void initialize(String ... fileNames) {
        String pathToFiles;
        if (this.initialized) {
            return;
        }
        ArrayList<InputStream> propertyFileStream = new ArrayList<InputStream>();
        InputStream defaultPropertiesStream = MwfPropertyUtils.class.getClassLoader().getResourceAsStream("default-plugin.properties");
        if (defaultPropertiesStream != null) {
            propertyFileStream.add(defaultPropertiesStream);
        }
        if (fileNames != null) {
            for (String fileName : fileNames) {
                InputStream fileStream = MwfPropertyUtils.class.getClassLoader().getResourceAsStream(fileName);
                if (fileStream == null) continue;
                propertyFileStream.add(fileStream);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(pathToFiles = System.getProperty("mwfProperties")))) {
            for (String path : pathToFiles.split(";")) {
                try {
                    propertyFileStream.add(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        for (InputStream is : propertyFileStream) {
            if (is == null) continue;
            try {
                this.properties.load(is);
                is.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.initialized = true;
    }

    public String getProperty(String key, String defaultValue) {
        String property = System.getProperty(key);
        return StringUtils.isBlank((CharSequence)property) ? this.properties.getProperty(key, defaultValue) : property;
    }

    public String getProperty(String key) {
        String property = System.getProperty(key);
        return StringUtils.isBlank((CharSequence)property) ? this.properties.getProperty(key) : property;
    }

    public boolean isDevMode(Environment environment) {
        boolean result = DEV_PROPERTIES.stream().anyMatch(prop -> (Boolean)environment.getProperty(prop, Boolean.class, (Object)false));
        return result;
    }

    public boolean isDevMode() {
        boolean result = DEV_PROPERTIES.stream().anyMatch(prop -> Boolean.parseBoolean(System.getProperty(prop, "false")));
        return result;
    }

    public boolean isDevLocalUi(Environment environment) {
        boolean result = DEV_UI_PROPERTIES.stream().anyMatch(prop -> (Boolean)environment.getProperty(prop, Boolean.class, (Object)false));
        return result;
    }

    public boolean isDevLocalUi() {
        boolean result = DEV_UI_PROPERTIES.stream().anyMatch(prop -> Boolean.parseBoolean(System.getProperty(prop, "false")));
        return result;
    }
}

