/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.statistics.job;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.moveworkforward.statistics.service.AbstractStatisticsService;
import com.moveworkforward.statistics.service.StatisticsService;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsJobRunner
implements JobRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticsJobRunner.class);

    private StatisticsService getStatisticsService() {
        try {
            return AbstractStatisticsService.INSTANCE;
        }
        catch (Exception e) {
            log.error("Error while getting statistics service", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            StatisticsService statisticsService = this.getStatisticsService();
            if (statisticsService == null) {
                log.error("Statistics service is not available");
                return JobRunnerResponse.failed((String)"Statistics service is not available");
            }
            boolean result = statisticsService.sendStatistics();
            log.info("Statistics sending result: {}", (Object)result);
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return JobRunnerResponse.failed((String)e.getMessage());
        }
    }
}

