/*
 * Decompiled with CFR 0.152.
 */
package com.moveworkforward.component;

import com.moveworkforward.component.ValidationHelper;
import com.moveworkforward.exception.DetailedException;
import com.moveworkforward.model.LevelPluginEntity;
import com.moveworkforward.model.SourcePluginEntity;
import com.moveworkforward.model.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValidationHelper
implements ValidationHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractValidationHelper.class);

    @Override
    public boolean hasReadPermissions(Object entity, User loggedUser) {
        User user;
        log.debug("Checking read permissions for the {} for user {}", this.loggableEntity(entity), (Object)loggedUser);
        User user2 = user = loggedUser == null ? this.getCurrentUser() : loggedUser;
        if (this.isGlobalAdmin(user)) {
            log.debug("User is a global admin");
            return true;
        }
        if (entity instanceof LevelPluginEntity && this.isPersonalLevel((LevelPluginEntity)entity) && !this.isOwner((LevelPluginEntity)entity, user)) {
            log.debug("User is not the owner");
            return false;
        }
        if (!(entity instanceof SourcePluginEntity)) {
            log.debug("Entity doesn't have sources");
            return false;
        }
        ArrayList<String> sourceKeys = new ArrayList<String>(Optional.ofNullable(((SourcePluginEntity)entity).getSourceKeys()).orElse(new ArrayList()));
        if (sourceKeys.isEmpty()) {
            sourceKeys.add(this.getGlobalKey());
        }
        return sourceKeys.stream().anyMatch(sourceKey -> {
            boolean result = true;
            if (this.isGlobalSourceKey((String)sourceKey)) {
                log.debug("User[{}] is not global admin", (Object)user);
                result = false;
            } else {
                result = this.hasSourceReadPermissions((String)sourceKey, user);
            }
            log.debug("User has permissions to read source {}: {}", sourceKey, (Object)result);
            return result;
        });
    }

    protected Object loggableEntity(Object entity) {
        return entity;
    }

    @Override
    public void checkReadPermissions(Object entity) {
        log.debug("Checking read permissions for the {}", this.loggableEntity(entity));
        if (!this.hasReadPermissions(entity, null)) {
            throw new IllegalArgumentException("User doesn't have permissions to read the configuration.");
        }
    }

    @Override
    public void checkWritePermissions(Object entity) {
        User user = this.getCurrentUser();
        log.debug("Checking write permissions for the {} for user {}", this.loggableEntity(entity), (Object)user);
        if (entity instanceof LevelPluginEntity && this.isPersonalLevel((LevelPluginEntity)entity) && !this.isOwner((LevelPluginEntity)entity, user)) {
            throw new IllegalArgumentException("User doesn't have permissions to save the configuration. Can't get permissions level.");
        }
        if (!(entity instanceof SourcePluginEntity)) {
            throw new IllegalArgumentException("User doesn't have permissions to save the configuration. Record doesn't have sources to check.");
        }
        ArrayList<String> sourceKeys = new ArrayList<String>(Optional.ofNullable(((SourcePluginEntity)entity).getSourceKeys()).orElse(new ArrayList()));
        if (sourceKeys.isEmpty()) {
            log.warn("Sources are empty, add GLOBAL level source");
            sourceKeys.add(this.getGlobalKey());
        }
        sourceKeys.forEach(sourceKey -> {
            log.debug("Checking write user permissions for the source: {}", sourceKey);
            if (this.isGlobalSourceKey((String)sourceKey)) {
                log.debug("'{}' is a global level source", sourceKey);
                if (!this.isGlobalAdmin(user)) {
                    log.error("User[{}] is not global admin", (Object)user);
                    throw new DetailedException("User doesn't have global permissions to save the configuration.", "sources");
                }
            } else if (!this.hasSourceWritePermissions((String)sourceKey, user)) {
                throw new DetailedException("User doesn't have permissions to save the configuration.", "sources");
            }
        });
    }

    @Override
    public void checkDeletePermissions(Object entity) {
        boolean hasPermissions;
        User user = this.getCurrentUser();
        log.debug("Checking delete permissions for the {} for user {}", this.loggableEntity(entity), (Object)user);
        if (this.isGlobalAdmin(user)) {
            log.debug("User is a global admin");
            return;
        }
        if (entity instanceof LevelPluginEntity && this.isPersonalLevel((LevelPluginEntity)entity) && !this.isOwner((LevelPluginEntity)entity, user)) {
            throw new IllegalArgumentException("User doesn't have permissions to delete configuration. Can't get permissions level.");
        }
        if (!(entity instanceof SourcePluginEntity)) {
            throw new IllegalArgumentException("User doesn't have permissions to delete configuration. Record doesn't have sources to check.");
        }
        ArrayList<String> sourceKeys = new ArrayList<String>(Optional.ofNullable(((SourcePluginEntity)entity).getSourceKeys()).orElse(new ArrayList()));
        if (sourceKeys.isEmpty()) {
            log.warn("Sources are empty, add GLOBAL level source");
            sourceKeys.add(this.getGlobalKey());
        }
        if (!(hasPermissions = sourceKeys.stream().allMatch(sourceKey -> {
            log.debug("Checking delete user permissions for the source: {}", sourceKey);
            boolean result = true;
            if (this.isGlobalSourceKey((String)sourceKey)) {
                log.debug("'{}' is a global level source", sourceKey);
                result = false;
            } else {
                result = this.hasSourceDeletePermissions((String)sourceKey, user);
            }
            log.debug("User has permissions to delete configuration {}: {}", sourceKey, (Object)result);
            return result;
        }))) {
            throw new DetailedException("User doesn't have permissions to delete this configuration.", "sources");
        }
    }

    @Override
    public boolean hasSourceDeletePermissions(String sourceKey, User user) {
        log.debug("Checking delete permissions for the source {} for user {}", (Object)sourceKey, (Object)user);
        boolean result = true;
        Object source = null;
        try {
            source = this.getSourceByKey(sourceKey);
        }
        catch (Exception e) {
            log.error("Source is not found by key: {}", source);
        }
        if (source != null && !this.isSourceAdmin(source, user)) {
            log.warn("User[{}] does not have permissions to delete source {}", (Object)user, (Object)sourceKey);
            result = false;
        }
        return result;
    }

    @Override
    public boolean hasSourceWritePermissions(String sourceKey, User user) {
        log.debug("Checking write permissions for the source {} for user {}", (Object)sourceKey, (Object)user);
        Object source = this.getSourceByKey(sourceKey);
        if (source == null) {
            throw new DetailedException("Source is not found by key: " + sourceKey, Arrays.asList(new DetailedException.ErrorHolder("Source is not found by key: " + sourceKey, "sources")));
        }
        boolean result = this.isSourceAdmin(source, user);
        log.debug("User[{}] has permissions to write the source {}: {}", new Object[]{user, sourceKey, result});
        return result;
    }

    @Override
    public boolean hasSourceReadPermissions(String sourceKey, User user) {
        boolean result;
        Object source;
        block3: {
            log.debug("Checking read permissions for the source {} for user {}", (Object)sourceKey, (Object)user);
            source = null;
            result = true;
            try {
                source = this.getSourceByKey(sourceKey);
            }
            catch (Exception e) {
                log.error("Source is not found by key: {}", source);
                if (this.isGlobalAdmin(user)) break block3;
                log.debug("User[{}] is not global admin", (Object)user);
                result = false;
            }
        }
        if (source != null && !this.isSourceAdmin(source, user)) {
            log.warn("User[{}] does not have permissions to read the source {}", (Object)user, (Object)sourceKey);
            result = false;
        }
        return result;
    }
}

