/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.validation;

import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.validation.AdminPermissionValidator;
import at.rumpelcoders.confluence.validation.LevelPermissionConstraint;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelPermissionValidator
implements ConstraintValidator<LevelPermissionConstraint, GitLabConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LevelPermissionValidator.class);
    @ComponentImport
    @Inject
    private PermissionManager permissionManager;

    @Override
    public boolean isValid(GitLabConfiguration configuration, ConstraintValidatorContext context) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (AdminPermissionValidator.isGlobalAdmin(this.permissionManager, confluenceUser)) {
            return true;
        }
        if (GitLabConfiguration.Level.PERSONAL.equals(configuration.getLevel())) {
            return confluenceUser.getKey().getStringValue().equals(configuration.getUserKey());
        }
        return false;
    }
}

