/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.resources;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.IssueFilterBuilder;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabIssue;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.beans.model.GitlabChartIssue;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.resources.AbstractGitLabResource;
import at.rumpelcoders.confluence.resources.AnnotatedNameValuePair;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/projects/issues")
@Named(value="issuesResource")
public class IssuesResource
extends AbstractGitLabResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssuesResource.class);

    @Inject
    public IssuesResource(ConfigurationManager configurationManager, GitlabApi gitlabApi) {
        super(configurationManager, gitlabApi);
    }

    @POST
    @Path(value="/chart")
    @Produces(value={"application/json"})
    public Response getIssuesForChart(IssuesChartRequest request) {
        try {
            String projectId = URLDecoder.decode(request.getProjectId(), StandardCharsets.UTF_8.displayName());
            GitlabConnection connection = this.getConnection(request.getGitLabBaseUrl());
            GitlabProject project = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
            IssueFilterBuilder filterBuilder = new IssueFilterBuilder(request.maxEntries).setOrderBy("created_at").setSort("Desc").setFromDate(request.getFromDate()).setToDate(request.getToDate());
            List<GitlabIssue> issues = StringUtils.isBlank((CharSequence)request.getMilestoneId()) ? this.gitlabApi.getIssues(connection, project.getId(), filterBuilder) : this.gitlabApi.getMilestoneIssues(connection, (Serializable)((Object)projectId), request.getMilestoneId(), filterBuilder);
            List chartIssues = issues.stream().map(i -> new GitlabChartIssue((GitlabIssue)i, project)).collect(Collectors.toList());
            GenericEntity<List<GitlabChartIssue>> entity = new GenericEntity<List<GitlabChartIssue>>(chartIssues){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fetching chart issues from gitlab", (Throwable)e);
            return Response.serverError().status(500).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response getIssueById(@QueryParam(value="projectId") String projectIdString, @QueryParam(value="issueId") String issueIdString, @QueryParam(value="baseUrl") String baseUrl) {
        try {
            String projectId = URLDecoder.decode(projectIdString, StandardCharsets.UTF_8.displayName());
            int issueId = Integer.parseInt(issueIdString);
            GitlabConnection connection = this.getConnection(baseUrl);
            GitlabIssue issue = this.gitlabApi.getIssue(connection, (Serializable)((Object)projectId), issueId);
            AnnotatedNameValuePair resourceProject = new AnnotatedNameValuePair(issue.getTitle(), issue.getId());
            GenericEntity<AnnotatedNameValuePair> entity = new GenericEntity<AnnotatedNameValuePair>(resourceProject){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fectching issues from gitlab", (Throwable)e);
            return Response.serverError().status(500).build();
        }
    }

    @GET
    @Path(value="/labels")
    @Produces(value={"application/json"})
    public Response getIssues(@QueryParam(value="projectId") String projectIdString, @QueryParam(value="label") String label, @QueryParam(value="baseUrl") String baseUrl) {
        try {
            String projectId = URLDecoder.decode(projectIdString, StandardCharsets.UTF_8.displayName());
            GitlabConnection connection = this.getConnection(baseUrl);
            GitlabProject project = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
            List<GitlabIssue> issues = this.gitlabApi.getIssues(connection, project, new Integer[0]);
            List resources = issues.stream().map(p -> new AnnotatedNameValuePair(p.getTitle(), p.getIid())).collect(Collectors.toList());
            GenericEntity<List<AnnotatedNameValuePair>> entity = new GenericEntity<List<AnnotatedNameValuePair>>(resources){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fectching issues from gitlab", (Throwable)e);
            return Response.serverError().status(500).build();
        }
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response getIssuesByName(@QueryParam(value="projectId") String projectIdString, @QueryParam(value="baseUrl") String baseUrl, @QueryParam(value="text") String text) {
        try {
            String projectId = URLDecoder.decode(projectIdString, StandardCharsets.UTF_8.displayName());
            GitlabConnection connection = this.getConnection(baseUrl);
            if (StringUtils.isBlank((CharSequence)connection.getUrl()) || StringUtils.isBlank((CharSequence)connection.getApiKey())) {
                throw new RuntimeException("GitLab is not configured");
            }
            List<GitlabIssue> issues = this.gitlabApi.searchIssues(connection, (Serializable)((Object)projectId), text);
            List resources = issues.stream().map(p -> new AnnotatedNameValuePair(p.getTitle(), p.getIid())).collect(Collectors.toList());
            GenericEntity<List<AnnotatedNameValuePair>> entity = new GenericEntity<List<AnnotatedNameValuePair>>(resources){};
            return Response.ok((Object)entity).build();
        }
        catch (GitLabApiException e) {
            log.error("error on fetching issues from gitlab", (Throwable)e);
            return Response.serverError().entity((Object)e.getCause().getMessage()).status(500).build();
        }
        catch (Exception e) {
            log.error("error on fetching issues from gitlab", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(500).build();
        }
    }

    @JsonAutoDetect
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class IssuesChartRequest {
        private String projectId;
        private String gitLabBaseUrl;
        private String milestoneId;
        private int maxEntries = 100;
        private String fromDate;
        private String toDate;

        @Generated
        public String getProjectId() {
            return this.projectId;
        }

        @Generated
        public String getGitLabBaseUrl() {
            return this.gitLabBaseUrl;
        }

        @Generated
        public String getMilestoneId() {
            return this.milestoneId;
        }

        @Generated
        public int getMaxEntries() {
            return this.maxEntries;
        }

        @Generated
        public String getFromDate() {
            return this.fromDate;
        }

        @Generated
        public String getToDate() {
            return this.toDate;
        }

        @Generated
        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Generated
        public void setGitLabBaseUrl(String gitLabBaseUrl) {
            this.gitLabBaseUrl = gitLabBaseUrl;
        }

        @Generated
        public void setMilestoneId(String milestoneId) {
            this.milestoneId = milestoneId;
        }

        @Generated
        public void setMaxEntries(int maxEntries) {
            this.maxEntries = maxEntries;
        }

        @Generated
        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        @Generated
        public void setToDate(String toDate) {
            this.toDate = toDate;
        }
    }
}

