/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.model;

import at.rumpelcoders.confluence.ao.converters.GitLabConfigurationConverter;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.model.LevelRecord;
import at.rumpelcoders.confluence.validation.LevelPermissionConstraint;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.moveworkforward.model.ConfigurationLevel;
import com.moveworkforward.v2.ao.Persistence;
import com.moveworkforward.v2.model.IdModel;
import com.moveworkforward.v2.validation.ValidationGroups;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.URL;

@Persistence(entityType="GITLAB_CONFIGURATION", converter=GitLabConfigurationConverter.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@LevelPermissionConstraint(groups={ValidationGroups.Save.class, ValidationGroups.Get.class})
@JsonAutoDetect
public class GitLabConfiguration
implements IdModel,
Cloneable,
LevelRecord {
    public static final String TYPE = "GITLAB_CONFIGURATION";
    public static final String ALL_SPACES = "05f11044-da77-41a8-ac66-a9388ffd0925";
    private Integer id;
    private String title = "GitLab Connection";
    private boolean enabled = true;
    @NotNull
    private Level level = Level.GLOBAL;
    private String userKey;
    @NotNull
    private String apiKey;
    @NotEmpty
    @URL
    private String serverUrl;
    @NotNull
    private GitlabConnection.HostType hostType = GitlabConnection.HostType.SERVER;

    public String getServerUrl() {
        return StringUtils.isBlank((CharSequence)this.serverUrl) ? this.serverUrl : this.serverUrl.trim().replaceAll("/$", "");
    }

    public GitLabConfiguration clone() {
        return (GitLabConfiguration)super.clone();
    }

    @Generated
    public GitLabConfiguration() {
    }

    @Override
    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Generated
    public String getUserKey() {
        return this.userKey;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public GitlabConnection.HostType getHostType() {
        return this.hostType;
    }

    @Override
    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setLevel(Level level) {
        this.level = level;
    }

    @Generated
    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Generated
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Generated
    public void setHostType(GitlabConnection.HostType hostType) {
        this.hostType = hostType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitLabConfiguration)) {
            return false;
        }
        GitLabConfiguration other = (GitLabConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitLabConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GitLabConfiguration(super=" + super.toString() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", enabled=" + this.isEnabled() + ", level=" + this.getLevel() + ", userKey=" + this.getUserKey() + ", apiKey=" + this.getApiKey() + ", serverUrl=" + this.getServerUrl() + ", hostType=" + this.getHostType() + ")";
    }

    public static enum Level implements ConfigurationLevel
    {
        GLOBAL,
        PERSONAL;

    }
}

