/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.mermaid;

import at.rumpelcoders.confluence.mermaid.MermaidCodeMacro;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class MermaidMacroPostProcessor
extends NodePostProcessor {
    @Override
    public void process(@NotNull NodeTracker state, @NotNull Node node) {
        if (node instanceof FencedCodeBlock) {
            Node previous = node.getPrevious();
            String info = ((FencedCodeBlock)node).getInfo().toString();
            if (info.equals("mermaid")) {
                Node parent = node.getParent();
                Node prev = node.getPrevious();
                Node next = node.getNext();
                BasedSequence text = ((FencedCodeBlock)node).getContentChars();
                MermaidCodeMacro mermaidCodeMacro = new MermaidCodeMacro(text);
                node.unlink();
                if (parent != null) {
                    if (prev != null) {
                        prev.insertAfter(mermaidCodeMacro);
                    } else if (next != null) {
                        next.insertBefore(mermaidCodeMacro);
                    } else {
                        parent.appendChild(mermaidCodeMacro);
                    }
                }
                state.nodeRemoved(node);
                state.nodeAddedWithChildren(mermaidCodeMacro);
            }
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodes(FencedCodeBlock.class);
        }

        @Override
        @NotNull
        public NodePostProcessor apply(@NotNull Document document) {
            return new MermaidMacroPostProcessor();
        }
    }
}

