/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabSnippet;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import at.rumpelcoders.confluence.utils.MarkdownToHTML;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="snippetMacro")
public class SnippetMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnippetMacro.class);
    public static final String USE_SNIPPET_ID_PARAMETER = "useSnippetId";
    public static final String SNIPPET_ID_PARAMETER = "snippetId";

    @Inject
    public SnippetMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport TemplateRenderer renderer) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider, renderer);
    }

    @Override
    public String doExecute(Map<String, String> parameters, String bodyContent, GitlabConnection connection, ConversionContext conversionContext) throws Exception {
        int snippetId = Integer.parseInt(parameters.get(SNIPPET_ID_PARAMETER));
        boolean showDescription = Boolean.parseBoolean(parameters.get("showDescription"));
        boolean useSnippetId = Boolean.parseBoolean(parameters.get(USE_SNIPPET_ID_PARAMETER));
        GitlabSnippet snippet = null;
        if (useSnippetId) {
            snippet = this.getPersonalSnippet(snippetId, connection);
        } else {
            int projectId = Integer.parseInt(parameters.get("project"));
            snippet = this.getProjectSnippet(snippetId, projectId, connection);
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("gitLabUrl", connection.getUrl());
        context.put("showDescription", showDescription);
        if (snippet != null) {
            context.put("snippet", snippet);
            context.put("uniqueId", UUID.randomUUID().toString());
            context.put("isMarkDown", snippet.getFileName().toLowerCase().endsWith(".md"));
            context.put("lineCount", snippet.getContent().split("\n").length);
        }
        return this.render("templates/snippet-macro.vm", context);
    }

    private GitlabSnippet getProjectSnippet(int snippetId, int projectId, GitlabConnection connection) throws GitLabApiException {
        try {
            if (projectId > 0 && snippetId > 0) {
                GitlabSnippet snippet = this.gitlabApi.getSnippet(connection, projectId, snippetId);
                snippet.setDescription(MarkdownToHTML.toHTML(snippet.getDescription()));
                return snippet;
            }
            throw new GitLabApiException(this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.issues-item.no-project-id"));
        }
        catch (Exception e) {
            log.error(String.format("error on fetching snippet %s for project %s", snippetId, projectId), (Throwable)e);
            throw e;
        }
    }

    private GitlabSnippet getPersonalSnippet(int snippetId, GitlabConnection connection) throws GitLabApiException {
        try {
            if (snippetId > 0) {
                GitlabSnippet snippet = this.gitlabApi.getSnippet(connection, snippetId);
                snippet.setDescription(MarkdownToHTML.toHTML(snippet.getDescription()));
                return snippet;
            }
            throw new GitLabApiException(this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.gitlab-api-snippet.no-snippet-id"));
        }
        catch (Exception e) {
            log.error(String.format("error on fetching snippet %s", snippetId), (Throwable)e);
            throw e;
        }
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.snippetmacro.error");
    }
}

