/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabCommit;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabMergeRequest;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabRelease;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="releaseMacro")
public class ReleaseMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReleaseMacro.class);
    public static final String TAG_PARAMETER = "tag";
    public static final String SHOW_MERGE_REQUESTS_PARAMETER = "showMergeRequests";
    public static final String SHOW_COMMITS_PARAMETER = "showCommits";
    public static final String COMMITS_COUNT_PARAMETER = "commitsCount";

    public ReleaseMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider, @ComponentImport TemplateRenderer renderer) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider, renderer);
    }

    @Override
    protected String doExecute(Map<String, String> parameters, String bodyContent, GitlabConnection connection, ConversionContext conversionContext) throws Exception {
        String projectId = URLDecoder.decode(parameters.get("project"), StandardCharsets.UTF_8.displayName());
        String tag = parameters.get(TAG_PARAMETER);
        if (StringUtils.isBlank((CharSequence)tag)) {
            return "Please provide a valid tag";
        }
        if ("latest".equalsIgnoreCase(tag)) {
            tag = "permalink/latest";
        }
        boolean showMergeRequests = this.getParameter(parameters, SHOW_MERGE_REQUESTS_PARAMETER, false);
        boolean showCommits = this.getParameter(parameters, SHOW_COMMITS_PARAMETER, false);
        int commitsCount = ReleaseMacro.parseInt(parameters.get(COMMITS_COUNT_PARAMETER), 100, "error on parsing commits count");
        GitlabProject gitlabProject = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
        GitlabRelease gitlabRelease = this.gitlabApi.getRelease(connection, gitlabProject.getId(), tag);
        Map context = MacroUtils.defaultVelocityContext();
        if (showCommits || showMergeRequests) {
            List<GitlabRelease> gitlabReleases = this.gitlabApi.getReleases(connection, gitlabProject.getId());
            gitlabReleases.sort(Comparator.comparing(GitlabRelease::getReleasedAt).reversed());
            int index = gitlabReleases.indexOf(gitlabRelease);
            if (gitlabReleases.size() > index + 1) {
                GitlabRelease previousRelease = gitlabReleases.get(index + 1);
                List<GitlabCommit> commits = this.gitlabApi.getCommits(connection, gitlabProject.getId(), previousRelease.getTagName(), gitlabRelease.getTagName(), commitsCount);
                if (showMergeRequests) {
                    context.put("mergeRequests", this.prepareMergeRequests(this.gitlabApi, connection, gitlabProject.getId(), commits, showCommits));
                } else {
                    context.put("commits", commits);
                }
            }
        }
        context.put("project", gitlabProject);
        context.put("gitLabUrl", connection.getUrl());
        context.put("release", gitlabRelease);
        return this.render("templates/release.vm", context);
    }

    private Map<GitlabMergeRequest, Set<GitlabCommit>> prepareMergeRequests(GitlabApi gitlabApi, GitlabConnection connection, int projectId, List<GitlabCommit> commits, boolean showCommits) {
        HashMap<GitlabMergeRequest, Set<GitlabCommit>> result = new HashMap<GitlabMergeRequest, Set<GitlabCommit>>();
        for (GitlabCommit commit : commits) {
            try {
                List<GitlabMergeRequest> mergeRequests = gitlabApi.getCommitMergeRequest(connection, projectId, commit.getId());
                mergeRequests.forEach(mergeRequest -> result.compute((GitlabMergeRequest)mergeRequest, (mr, commitSet) -> {
                    if (commitSet == null) {
                        commitSet = new HashSet<GitlabCommit>();
                    }
                    if (showCommits) {
                        commitSet.add(commit);
                    }
                    return commitSet;
                }));
            }
            catch (Exception e) {
                log.error("Error while fetching merge requests for commit " + commit.getId(), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.release.error");
    }
}

