/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.MilestonesFilterBuilder;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabMilestone;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import at.rumpelcoders.confluence.utils.MarkdownToHTML;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="milestonesMacro")
public class MilestonesMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MilestonesMacro.class);
    public static final String PROJECT_PARAMETER = "project";
    public static final String STATE_PARAMETER = "state";
    public static final String MILESTONE_ID_PARAMTER = "milestoneId";
    public static final String SEARCH_PARAMETER = "search";
    public static final String MAXIMUMENTRIES_PARAMETER = "maximumentries";

    @Autowired
    public MilestonesMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport TemplateRenderer renderer) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider, renderer);
    }

    @Override
    protected String doExecute(Map<String, String> parameters, String bodyContent, GitlabConnection connection, ConversionContext conversionContext) throws Exception {
        GitlabProject project;
        List<GitlabMilestone> milestones;
        block12: {
            String projectId = parameters.get(PROJECT_PARAMETER);
            String state = parameters.get(STATE_PARAMETER);
            String search = parameters.get(SEARCH_PARAMETER);
            int miximumEntries = -1;
            int milestoneId = -1;
            try {
                milestoneId = Integer.parseInt(parameters.get(MILESTONE_ID_PARAMTER));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                miximumEntries = Integer.parseInt(parameters.getOrDefault(MAXIMUMENTRIES_PARAMETER, String.valueOf(50)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            milestones = null;
            project = null;
            try {
                if (StringUtils.isNotBlank((CharSequence)projectId)) {
                    projectId = URLDecoder.decode(projectId, StandardCharsets.UTF_8.displayName());
                    project = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
                    if (milestoneId > 0) {
                        try {
                            GitlabMilestone milestone2 = this.gitlabApi.getMilestone(connection, project.getId(), milestoneId);
                            milestones = Collections.singletonList(milestone2);
                        }
                        catch (Exception e) {
                            log.warn("Could not get milestone, trying iid: " + milestoneId);
                            MilestonesFilterBuilder filterBuilder = new MilestonesFilterBuilder().setIIds(Collections.singletonList(milestoneId));
                            milestones = this.gitlabApi.getMilestones(connection, project.getId(), filterBuilder);
                        }
                    } else {
                        MilestonesFilterBuilder filterBuilder = new MilestonesFilterBuilder().setState(state).setSearch(search).setMaximumEntries(miximumEntries);
                        milestones = this.gitlabApi.getMilestones(connection, project.getId(), filterBuilder);
                    }
                    if (milestones.isEmpty()) {
                        throw new GitLabApiException("No milestones found for project: " + project.getName());
                    }
                    break block12;
                }
                throw new GitLabApiException(this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.issues-item.no-project-id"));
            }
            catch (Exception e) {
                log.error(String.format("error on fetching milestones for key %s", projectId), (Throwable)e);
                throw e;
            }
        }
        milestones.forEach(milestone -> {
            if (StringUtils.isNotBlank((CharSequence)milestone.getDescription())) {
                milestone.setDescription(MarkdownToHTML.convertMarkdownToHtml(milestone.getDescription()));
            } else {
                milestone.setDescription(null);
            }
        });
        Map context = MacroUtils.defaultVelocityContext();
        context.put("gitLabUrl", connection.getUrl());
        context.put(PROJECT_PARAMETER, project);
        context.put("milestones", milestones);
        return this.render("templates/milestones-macro.vm", context);
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.milestonessmacro.error");
    }
}

