/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabMilestone;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import javax.inject.Named;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="issuesGanttChartMacro")
public class IssuesGanttChartMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IssuesGanttChartMacro.class);
    public static final String FROM_DATE_PARAMETER = "fromDate";
    public static final String TO_DATE_PARAMETER = "toDate";

    @Autowired
    public IssuesGanttChartMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider, TemplateRenderer renderer) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider, renderer);
    }

    @Override
    protected String doExecute(Map<String, String> parameters, String bodyContent, GitlabConnection connection, ConversionContext conversionContext) throws Exception {
        String gitLabBaseUrl = parameters.get("baseUrl");
        String projectId = parameters.get("project");
        int maxEntries = 100;
        try {
            maxEntries = Integer.parseInt(parameters.getOrDefault("maximumentries", "100"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int milestoneId = -1;
        try {
            milestoneId = Integer.parseInt(parameters.get("milestoneId"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("gitLabBaseUrl", gitLabBaseUrl);
        context.put("projectId", projectId);
        context.put("baseUrl", this.getBaseUrl());
        context.put("uniqueId", UUID.randomUUID().toString());
        context.put("maxEntries", maxEntries);
        String fromDate = parameters.get(FROM_DATE_PARAMETER);
        String toDate = parameters.get(TO_DATE_PARAMETER);
        if (StringUtils.isNotBlank((CharSequence)fromDate)) {
            context.put(FROM_DATE_PARAMETER, fromDate);
        }
        if (StringUtils.isNotBlank((CharSequence)toDate)) {
            context.put(TO_DATE_PARAMETER, toDate);
        }
        if (milestoneId > 0) {
            GitlabMilestone milestone = this.gitlabApi.getMilestone(connection, (Serializable)((Object)projectId), milestoneId);
            GitlabProject project = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
            milestone.setDescription(null);
            context.put("milestone", milestone);
            context.put("project", project);
            context.put("milestoneId", milestoneId);
        }
        return this.render("templates/issues-gantt-chart-macro.vm", context);
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.issuesmacro.error");
    }
}

