/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.gitlab.api.models.GitlabGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="groupsMacro")
public class GroupsMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupsMacro.class);
    public static final String SHOW_ONLY_DIRECT_GROUPS = "showOnlyDirectGroups";

    @Inject
    public GroupsMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport TemplateRenderer renderer) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider, renderer);
    }

    @Override
    public String doExecute(Map<String, String> parameters, String bodyContent, GitlabConnection connection, ConversionContext conversionContext) throws Exception {
        boolean showOnlyDirectGroups = true;
        String showOnlyDirectGroupsString = parameters.get(SHOW_ONLY_DIRECT_GROUPS);
        if (showOnlyDirectGroupsString != null) {
            showOnlyDirectGroups = Boolean.parseBoolean(showOnlyDirectGroupsString);
        }
        Integer groupId = GroupsMacro.parseInt(parameters.get("group"), -1, "error on parsing group id");
        int count = GroupsMacro.parseInt(parameters.get("count"), 100, "error on parsing count");
        List<GitlabGroup> groups = null;
        groups = !groupId.equals(-1) ? this.gitlabApi.getGitlabSubGroups(connection, groupId, count, showOnlyDirectGroups) : this.gitlabApi.getGitlabGroups(connection, count, showOnlyDirectGroups);
        Map context = MacroUtils.defaultVelocityContext();
        context.put("groups", groups);
        return this.render("templates/groups-macro.vm", context);
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.groupsmacro.error");
    }
}

