/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.IssueFilterBuilder;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabEpic;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabEpicIssues;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabIssue;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import at.rumpelcoders.confluence.utils.MarkdownToHTML;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="epicsMacro")
public class EpicsMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EpicsMacro.class);
    public static final String GROUP_PARAMETER = "group";
    public static final String EPIC_PARAMETER = "epic";

    public EpicsMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport TemplateRenderer renderer) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider, renderer);
    }

    @Override
    public String doExecute(Map<String, String> parameters, String bodyContent, GitlabConnection connection, ConversionContext conversionContext) throws Exception {
        int groupId = -1;
        int epicIid = -1;
        IssueFilterBuilder filterBuilder = new IssueFilterBuilder();
        groupId = Integer.parseInt(parameters.get(GROUP_PARAMETER));
        epicIid = Integer.parseInt(parameters.get(EPIC_PARAMETER));
        try {
            filterBuilder = new IssueFilterBuilder(Integer.parseInt(parameters.getOrDefault("maximumentries", "0")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Object> issues = new ArrayList();
        GitlabEpic epic = null;
        try {
            if (groupId <= 0 || epicIid <= 0) {
                throw new GitLabApiException(this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.issues-item.no-group-id"));
            }
            epic = this.gitlabApi.getGitlabEpic(connection, groupId, epicIid);
            GitlabEpicIssues gitlabEpicIssues = this.gitlabApi.getGitlabEpicIssues(connection, groupId, epicIid, filterBuilder);
            issues = gitlabEpicIssues.getIssues();
            epic.setOpenCount(gitlabEpicIssues.getOpenCount());
            epic.setClosedCount(gitlabEpicIssues.getClosedCount());
        }
        catch (Exception e) {
            log.error(String.format("error on fetching issues for group %s, epic %s", groupId, epicIid), (Throwable)e);
            throw e;
        }
        if (issues != null) {
            for (GitlabIssue gitlabIssue : issues) {
                gitlabIssue.setDescription(MarkdownToHTML.toHTML(gitlabIssue.getDescription()));
            }
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("gitLabUrl", connection.getUrl());
        context.put(EPIC_PARAMETER, epic);
        if (!issues.isEmpty()) {
            context.put("issues", issues);
        }
        return this.render("templates/epic-macro.vm", context);
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.epicsmacro.error");
    }
}

