/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabCommit;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabCommitDiff;
import at.rumpelcoders.confluence.beans.apiwrapper.GitlabProject;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.macros.BaseGitLabMacro;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="commitMacro")
public class CommitMacro
extends BaseGitLabMacro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommitMacro.class);
    private static final String COMMIT_HASH_PARAMETER = "commitHash";
    private static final String SHOW_DIFF_PARAMETER = "showDiff";

    @Inject
    public CommitMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport WebResourceUrlProvider webResourceUrlProvider, @ComponentImport TemplateRenderer renderer) {
        super(gitlabApi, configurationManager, licenseManager, i18nResolver, webResourceUrlProvider, renderer);
    }

    @Override
    protected String doExecute(Map<String, String> parameters, String bodyContent, GitlabConnection connection, ConversionContext conversionContext) throws Exception {
        String projectId = URLDecoder.decode(parameters.get("project"), StandardCharsets.UTF_8.displayName());
        String commitHash = parameters.get(COMMIT_HASH_PARAMETER);
        if (StringUtils.isBlank((CharSequence)commitHash)) {
            return "Please provide a valid commit hash";
        }
        boolean showDiff = false;
        String showDiffString = parameters.get(SHOW_DIFF_PARAMETER);
        if (showDiffString != null) {
            showDiff = Boolean.parseBoolean(showDiffString);
        }
        GitlabProject project = null;
        GitlabCommit commit = null;
        ArrayList<GitlabCommitDiff> commitDiffs = new ArrayList();
        try {
            project = this.gitlabApi.getProject(connection, (Serializable)((Object)projectId), false);
            commit = this.gitlabApi.getCommit(connection, project.getId(), commitHash);
            if (showDiff) {
                commitDiffs = this.gitlabApi.getCommitDiff(connection, project.getId(), commitHash);
            }
        }
        catch (Exception e) {
            log.error(String.format("error on fetching builds for key %s", projectId), (Throwable)e);
            throw e;
        }
        Map context = MacroUtils.defaultVelocityContext();
        context.put("gitLabUrl", connection.getUrl());
        context.put("project", project);
        context.put("commit", commit);
        this.collectDiffFiles(context, commitDiffs, "addedFiles", GitlabCommitDiff::isNewFile);
        this.collectDiffFiles(context, commitDiffs, "deletedFiles", GitlabCommitDiff::isDeletedFile);
        this.collectDiffFiles(context, commitDiffs, "renamedFiles", GitlabCommitDiff::isRenamedFile);
        this.collectDiffFiles(context, commitDiffs, "modifiedFiles", diff -> !diff.isDeletedFile() && !diff.isRenamedFile() && !diff.isNewFile());
        return this.render("templates/commit-macro.vm", context);
    }

    private void collectDiffFiles(Map<String, Object> context, List<GitlabCommitDiff> commitDiffs, String name, Function<GitlabCommitDiff, Boolean> filter) {
        List files = commitDiffs.stream().filter(filter::apply).collect(Collectors.toList());
        if (!files.isEmpty()) {
            context.put(name, files);
        }
    }

    @Override
    protected String getMacroErrorPrefix() {
        return this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.commitmacro.error");
    }
}

