/*
 * Decompiled with CFR 0.152.
 */
package at.rumpelcoders.confluence.macros;

import at.rumpelcoders.confluence.api.GitlabApi;
import at.rumpelcoders.confluence.beans.GitLabApiException;
import at.rumpelcoders.confluence.beans.GitlabConnection;
import at.rumpelcoders.confluence.components.ConfigurationManager;
import at.rumpelcoders.confluence.components.LicenseManager;
import at.rumpelcoders.confluence.model.GitLabConfiguration;
import at.rumpelcoders.confluence.model.GlobalSettings;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.WebResourceUrlProvider;
import com.opensymphony.xwork2.validator.validators.URLValidator;
import java.io.FileNotFoundException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.gitlab.api.GitlabAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGitLabMacro
implements Macro {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseGitLabMacro.class);
    public static final String COUNT = "count";
    public static final String BASE_URL_PARAMETER = "baseUrl";
    public static final String TEMPLATES_INVALID_LICENSE = "templates/invalid-license.vm";
    protected GitlabApi gitlabApi;
    protected ConfigurationManager configurationManager;
    protected LicenseManager licenseManager;
    protected I18nResolver i18nResolver;
    protected WebResourceUrlProvider webResourceUrlProvider;
    protected TemplateRenderer renderer;

    public BaseGitLabMacro(GitlabApi gitlabApi, ConfigurationManager configurationManager, LicenseManager licenseManager, I18nResolver i18nResolver, WebResourceUrlProvider webResourceUrlProvider, TemplateRenderer renderer) {
        this.gitlabApi = gitlabApi;
        this.configurationManager = configurationManager;
        this.licenseManager = licenseManager;
        this.i18nResolver = i18nResolver;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.renderer = renderer;
    }

    public static int parseInt(String value, int defaultValue, String errorMessage) {
        try {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception e) {
            log.error(errorMessage, (Throwable)e);
        }
        return defaultValue;
    }

    protected boolean getParameter(Map<String, String> parameters, String name, boolean defaultValue) {
        boolean result = defaultValue;
        String showReleasesString = parameters.get(name);
        if (showReleasesString != null) {
            result = Boolean.parseBoolean(showReleasesString);
        }
        return result;
    }

    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.hasValidLicense()) {
            return this.getLicensingErrorString();
        }
        GlobalSettings globalSettings = this.configurationManager.getGlobalSettings();
        if (!globalSettings.isAllowedSpace(conversionContext.getSpaceKey())) {
            Map context = MacroUtils.defaultVelocityContext();
            return this.render("templates/not-allowed-space.vm", context);
        }
        String baseUrl = parameters.get(BASE_URL_PARAMETER);
        List<GitlabConnection> connections = this.getConnections(baseUrl);
        if (connections.isEmpty()) {
            return this.handleError("No valid configurations are found", true, parameters);
        }
        LinkedHashMap<String, String> errorsMap = new LinkedHashMap<String, String>();
        for (GitlabConnection connection : connections) {
            try {
                return this.doExecute(parameters, bodyContent, connection, conversionContext);
            }
            catch (GitLabApiException apiException) {
                errorsMap.put(connection.getUrl(), this.getErrorMessageFromException(apiException));
            }
            catch (Exception e2) {
                log.error(e2.getMessage(), (Throwable)e2);
                errorsMap.put(connection.getUrl(), this.i18nResolver.getText("at.rumpelcoders.confluence.gitlab-api.unexpected.error"));
            }
        }
        if (errorsMap.size() > 1) {
            return this.handleError(errorsMap.entrySet().stream().map(e -> (String)e.getKey() + ": " + (String)e.getValue()).collect(Collectors.joining("<br/>")), parameters);
        }
        return this.handleError(String.join((CharSequence)"<br/>", errorsMap.values()), parameters);
    }

    protected abstract String doExecute(Map<String, String> var1, String var2, GitlabConnection var3, ConversionContext var4) throws Exception;

    protected boolean hasValidLicense() {
        return this.licenseManager.isLicensed();
    }

    protected String getLicensingErrorString() {
        Map context = MacroUtils.defaultVelocityContext();
        return this.render(TEMPLATES_INVALID_LICENSE, context);
    }

    protected List<GitlabConnection> getConnections(String baseUrl) {
        List<GitLabConfiguration> configuration = this.configurationManager.getSuitableConfigurations(baseUrl);
        GlobalSettings globalSettings = this.configurationManager.getGlobalSettings();
        return configuration.stream().map(c -> new GitlabConnection.Builder().config((GitLabConfiguration)c, globalSettings.getRequestTimeout()).build()).filter(GitlabConnection::isValid).collect(Collectors.toList());
    }

    protected String getErrorMessageFromException(GitLabApiException apiException) {
        String errorText;
        log.error(apiException.getMessage(), (Throwable)apiException);
        try {
            if (apiException.getCause() instanceof FileNotFoundException) {
                return "Resource is not found";
            }
            if (apiException.getCause() instanceof GitlabAPIException) {
                JSONObject jsonObject = new JSONObject(apiException.getCause().getMessage());
                errorText = (String)jsonObject.get("message");
            } else {
                errorText = apiException.getMessage();
            }
        }
        catch (Exception e) {
            errorText = apiException.getMessage();
        }
        return errorText;
    }

    protected String handleError(String errorText, Map<String, String> parameters) {
        return this.handleError(errorText, false, parameters);
    }

    protected String handleError(String errorText, boolean setupError, Map<String, String> parameters) {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("errorMacroPrefix", this.getMacroErrorPrefix());
        context.put("errorText", errorText);
        context.put("setupError", setupError);
        context.put(BASE_URL_PARAMETER, this.getBaseUrl());
        String defaultResult = this.render("templates/error.vm", context);
        String link = parameters.get("link");
        if (StringUtils.isBlank((CharSequence)link)) {
            return defaultResult;
        }
        if (!(link = URLDecoder.decode(link, StandardCharsets.UTF_8.displayName())).matches(new URLValidator().getUrlRegex())) {
            return defaultResult;
        }
        return String.format("<a href=\"%s\">%s</a>", link, link) + defaultResult;
    }

    protected String render(String template, Map<String, Object> model) {
        try {
            log.debug("Model for rendering: {}", model);
            StringWriter stringWriter = new StringWriter();
            this.renderer.render(template, model, (Writer)stringWriter);
            stringWriter.flush();
            stringWriter.close();
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "Can't render";
        }
    }

    protected abstract String getMacroErrorPrefix();

    public String getBaseUrl() {
        return this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

